<?php
 /* ======================================================================================================================================================
 -- Author: Saquib Patwa
 -- Create date: 09/23/2019
 -- Description: Contact form for IT Help Desk/Phoenix and HR

 -- MODIFICATION
 -- Last Modified Date: 10/07/2019 -
 -- Last Modified Date: 03/24/2021 - Added Branch and Department to IT, Phoenix & HR options
 -- Last Modified Date: 03/24/2021 - Added a button & form 'Personnel Action Notice Form'
 -- Last Modified Date: 07/07/2021 - Finished working on Personnel Action Notice Form
 -- Last Modified Date: 07/19/2021 - added attachment and some formatting changes
 -- Last Modified Date: 07/28/2021 - Added Forwarding the user's email to another radio button and employee Name to SEPARATION section of the PAN Form
 -- Last Modified Date: 09/16/2021 - Addred functionality to CHANGE & SEPARATION (radio buttons) to remove ADDRESS, CITY, STATE, ZIP & TELEPHONE
 -- Last Modified Date: 09/17/2021 - Date picker was not working on Mobile devices so corrected that for all date pickers.
 -- Last Modified Date: 09/18/2021 - Using EMAIL from endpoint for "FROMEMAIL"
 -- ======================================================================================================================================================= */

 // to show all errors
 error_reporting(E_ALL);
 ini_set('display_errors', '1');

 // To hide all errors
 // error_reporting(0);
 // ini_set('display_errors', 0);

 // include('../helpdesk/connection.php');

 // Using database connection file here
include_once "db_connection.php";







// PERSONNEL ACTION NOTICE

// session_start();


 $postData1 = $uploadedFile = $statusMsg = '';
 $msgClass = 'errordiv';

 if(isset($_POST['submit2'])){


     // Get the submitted form data
     $postData1 = $_POST;
     $id = mysqli_real_escape_string($conn,$_POST['newhire_ID']);
     $first_name = mysqli_real_escape_string($conn,$_POST['first_name']);
     $last_name = mysqli_real_escape_string($conn,$_POST['last_name']);
     $effective_date = mysqli_real_escape_string($conn,$_POST['effective_date']);
     // $effective_date = date("d-m-Y", strtotime($_POST['effective_date']));
     $branch = mysqli_real_escape_string($conn,$_POST['branch']);
     $department = mysqli_real_escape_string($conn,$_POST['department']);
     $employeeID = mysqli_real_escape_string($conn,$_POST['employeeID']);
     $address= mysqli_real_escape_string($conn,$_POST['address']);
     $city = mysqli_real_escape_string($conn,$_POST['city']);
     $state = mysqli_real_escape_string($conn,$_POST['state']);
     $zip = mysqli_real_escape_string($conn,$_POST['zip']);
     $telephone = mysqli_real_escape_string($conn,$_POST['telephone']);
     $from_email = mysqli_real_escape_string($conn,$_SESSION['from_email']);
     $attachment = mysqli_real_escape_string($conn,$_POST['fileName']);
     // $_SESSION['Department'] = htmlentities($_POST['email']);

     // Session Variables


     // New Hire Section
     $Hire_Reason = mysqli_real_escape_string($conn,$_POST['Hire_Reason']);
     $replacement_for = mysqli_real_escape_string($conn,$_POST['replacement_for']);
     $employment_Status = mysqli_real_escape_string($conn,$_POST['employment_Status']);
     $drivers_Licence = mysqli_real_escape_string($conn,$_POST['drivers_Licence']);
     $state_Issued = mysqli_real_escape_string($conn,$_POST['state_Issued']);
     $date_of_Birth = mysqli_real_escape_string($conn,$_POST['date_of_Birth']);
     $gender = mysqli_real_escape_string($conn,$_POST['gender']);
     $ethnic_Code = mysqli_real_escape_string($conn,$_POST['ethnic_Code']);
     $marital_Status = mysqli_real_escape_string($conn,$_POST['marital_Status']);
     // $job_Title = implode(', ',array_keys($_SESSION['job_Title']));
     $job_Title = $_SESSION['job_Title'];
     $job_Title = mysqli_real_escape_string($conn,$_POST['job_Title']);
     $starting_Rate = mysqli_real_escape_string($conn,$_POST['starting_Rate']);
     $per = mysqli_real_escape_string($conn,$_POST['per']);
     $bonus_Commission_Plan = mysqli_real_escape_string($conn,$_POST['bonus_Commission_Plan']);
     $bonus_Level = mysqli_real_escape_string($conn,$_POST['bonus_Level']);
     $other = mysqli_real_escape_string($conn,$_POST['other']);
     $New_Hire_Remarks = mysqli_real_escape_string($conn,$_POST['New_Hire_Remarks']);

     // CHANGE
    $Job_Title_From = $_SESSION['job_Title'];
    $Job_Title_To = $_SESSION['job_Title'];
    $Pay_From = $_POST['Pay_From'];
    $Pay_From_Per = $_POST['Pay_From_Per'];
    $Pay_To = $_POST['PayTo'];
    $Pay_To_Per = $_POST['Pay_To_Per'];
    $From_Branch = $_POST['From_Branch'];
    $To_Branch = $_POST['To_Branch'];
    $From_Department = $_POST['From_Department'];
    $To_Department = $_POST['To_Department'];
    $From_Employee_Status = $_POST['From_Employee_Status'];
    $To_Employee_Status = $_POST['To_Employee_Status'];
    $Change_Remarks = $_POST['Change_Remarks'];

    // SEPARATION
    $Hire_Date = $_POST['Hire_Date'];
    $Last_Day_Worked = $_POST['Last_Day_Worked'];
    $Separation_Date = $_POST['Separation_Date'];
    $Separation_Type = $_POST['Separation_Type'];
    $Separation_Reason = $_POST['Separation_Reason'];
    $Eligible_to_Rehire = $_POST['Eligible_to_Rehire'];
    $forward_emails = $_POST['forward_emails'];
    $forwarding_to_employee_name = $_POST['forwarding_to_employee_name'];
    $Separation_Remarks = $_POST['Separation_Remarks'];

    // $rowCount ='';






//     $sql = "SELECT * FROM PAN_newhires";
//
// $result = $conn->query($sql);
//
// if ($result->num_rows > 0) {
//   // output data of each row
//   while($row = $result->fetch_assoc()) {
//     echo "id: " . $row["newhire_ID"]. " - Name: " . $row["first_name"]. " " . $row["last_name"]. "<br>";
//   }
// } else {
//   echo "0 results";
// }
// $conn->close();



// $sql1 = "INSERT INTO PAN_newhires (first_name, last_name)
// VALUES ('$first_name', 'Doe')";
//
// if ($conn->query($sql1) === TRUE) {
//   echo "New record created successfully";
// } else {
//   echo "Error: " . $sql1 . "<br>" . $conn->error;
// }

// $conn->close();



//   if(!mysqli_query($conn, $query))
// {
//     die("DAMMIT");
// }
// else{ echo "Success"; }

// mysqli_close($conn);

  // if(!$query)
  // {
  //     echo mysqli_error();
  // }
  // else
  // {
  //     echo "Records added successfully.";
  // }

// $result = mysqli_query($conn,$query);


    // $query .= implode(', ', $key);

    //query execution
    // if($conn->query($query)===TRUE){
    //   echo "Inserted Successfully";
    //   echo nl2br("\n$first_name\n $last_name\n ");
    //    $conn->close();
    //
    // }else{
    //   echo "Insert Failed ".$conn->error;
    //   $conn->close();
    // }

     // mysqli_close($conn); // Close connection



    // Check whether submitted data is not empty
    if(!empty($from_email)){

        // Validate email
         if(filter_var($from_email, FILTER_VALIDATE_EMAIL) === false){
            $statusMsg = 'Please enter your valid email.';
        }else{
            $uploadStatus = 1;

            // Upload attachment file
            if(!empty($_FILES["attachment"]["name"])){

                // File path config
                $targetDir = "/home/econicsd/public_html/selectransportation.com/hdesk/helpdesk/uploads/";
                $fileName = basename($_FILES["attachment"]["name"]);
                $targetFilePath = $targetDir . $fileName;
                $fileType = pathinfo($targetFilePath,PATHINFO_EXTENSION);

              //   $sql = "SELECT newhire_ID, first_name, last_name FROM PAN_newhires";
              // $result = mysqli_query($conn, $sql);
              //
              //
              //     if (mysqli_num_rows($result) > 0) {
              //   // output data of each row
              //   while($row = mysqli_fetch_assoc($result)) {
              //     echo "id: " . $row["newhire_ID"]. " - Name: " . $row["first_name"]. " " . $row["last_name"]. "<br>";
              //   }
              // } else {
              //   echo "0 results";
              // }
              //
              // // mysqli_close($conn);



                // Allow certain file formats
               $allowTypes = array('pdf', 'doc', 'docx', 'jpg', 'png', 'jpeg', 'xls', 'xlsx', 'txt');
                if(in_array($fileType, $allowTypes)){
                    // Upload file to the server
                    if(move_uploaded_file($_FILES["attachment"]["tmp_name"], $targetFilePath)){
                      // This commented out displays on web and uncomment to attach to email
                        $uploadedFile = $targetFilePath;
                        // Insert image file name into database
                        // $insert = $conn->query("INSERT INTO PAN_newhire (Attachment) VALUES ('".$fileName."') WHERE newhire_ID = newhire_ID");
                    }else{
                        $uploadStatus = 0;
                        $statusMsg = "Sorry, there was an error uploading your file.";
                    }
                }else{
                    $uploadStatus = 0;
                    $statusMsg = 'Sorry, only PDF, DOC, JPG, JPEG, & PNG files are allowed to upload.';
                }
            }



            $query= "INSERT INTO
              PAN_newhires (
                first_name,
                last_name,
                effective_date,
                branch,
                department,
                address,
                city,
                state,
                zip,
                telephone,
                Hire_Reason,
                replacement_for,
                employment_Status,
                drivers_Licence,
                state_Issued,
                date_of_Birth,
                gender,
                ethnic_Code,
                marital_Status,
                job_Title,
                starting_Rate,
                per,
                bonus_Commission_Plan,
                bonus_Level,
                other,
                New_Hire_Remarks,
                Attachment
              )
            VALUES(
                '$first_name',
                '$last_name',
                '$effective_date',
                '$branch',
                '$department',
                '$address',
                '$city',
                '$state',
                '$zip',
                '$telephone',
                '$Hire_Reason',
                '$replacement_for',
                '$employment_Status',
                '$drivers_Licence',
                '$state_Issued',
                '$date_of_Birth',
                '$gender',
                '$ethnic_Code',
                '$marital_Status',
                '$job_Title',
                '$starting_Rate',
                '$per',
                '$bonus_Commission_Plan',
                '$bonus_Level',
                '$other',
                '$New_Hire_Remarks',
                '$fileName'
              )";

              // mysql_select_db('PAN');
              $db_select = mysqli_select_db($conn, DB_NAME);


              if ($conn->query($query) === TRUE) {
                echo "New record created successfully";
              } else {
                echo "Error: " . $query . "<br>" . $conn->error;
              }



            //Get the auto-increment id value
            $id = mysqli_insert_id($conn);

            // $id = "SELECT LAST_INSERT_ID() FROM PAN_newhires";



            // printf("New record has ID  is %d.\n", $id);


            // printf("New record has ID %d.\n", mysqli_insert_id($conn));


            // $conn->close();


























             if($uploadStatus == 1){

                 $toEmail="";
                 // echo "hi";
                  // $pnEmail= "basspollution@yahoo.com";

                  // Recipient
                  // $pnEmail= "saquib.patwa@strhouston.com";

                  // $pnEmail= implode(", ", ["saquib.patwa@strhouston.com", $from_email]);
                  // $pnEmail= implode(", ", ["HRMail@strcorpus.com", $from_email]);





                  // $subject="";
                  $PNsubject = "PERSONNEL ACTION NOTICE";

                  // Section title: new hire, change, separation
                  $section= isset($_POST['personnelOnly']);


                  $job_Title = $_SESSION['job_Title'];




                  // $PartsEmailGroup = '';


                  // $NewTruckEmailGroup = '';
                  // $UsedTruckEmailGroup = '';
                  // $PartsEmailGroup = '';
                  // $ServiceEmailGroup = '';
                  // $BodyShopEmailGroup = '';
                  // $AccountingEmailGroup = '';
                  // $AdminEmailGroup = '';
                  // $ITEmailGroup = '';

                  $NewTruckEmailGroup = $_SESSION['NewTruckEmailGroup'];
                  $UsedTruckEmailGroup = $_SESSION['UsedTruckEmailGroup'];
                  $PartsEmailGroup = $_SESSION['PartsEmailGroup'];
                  $ServiceEmailGroup = $_SESSION['ServiceEmailGroup'];
                  $BodyShopEmailGroup = $_SESSION['BodyShopEmailGroup'];
                  $AccountingEmailGroup = $_SESSION['AccountingEmailGroup'];
                  $AdminEmailGroup = $_SESSION['AdminEmailGroup'];
                  $ITEmailGroup = $_SESSION['ITEmailGroup'];
                  $HREmailGroup = $_SESSION['HREmailGroup'];




                  // if (isset($_POST['department'])){
                  //     $department = $_POST['department'];
                  // } else if (isset($_GET['department'])) {
                  //     $department = $_GET['department'];
                  // } else {
                  //     $department = 'chooseListing';
                  // }



              if (isset($_POST['department'])) {
                $department = $_POST['department'];
                  switch ($_POST['department']) {

                      case "New Truck":
                        $toEmail=$NewTruckEmailGroup;
                         $subject = $PNsubject;
                        echo $toEmail;

                      break;

                      case "Used Truck":
                        $toEmail=$UsedTruckEmailGroup;
                         $subject = $PNsubject;
                        echo $toEmail;

                      break;

                      case "Parts":

                        $toEmail=$PartsEmailGroup;
                         $subject = $PNsubject;
                        echo $toEmail;

                      break;

                      case "Service":
                        $toEmail=$ServiceEmailGroup;
                         $subject = $PNsubject;
                        echo $toEmail;

                      break;


                      case "Body Shop":
                        $toEmail=$BodyShopEmailGroup;
                         $subject = $PNsubject;
                        echo $toEmail;

                      break;

                      case "Accounting":
                        $toEmail=$AccountingEmailGroup;
                         $subject = $PNsubject;
                        echo $toEmail;

                      break;

                      case "Administration":
                        $toEmail=$AdminEmailGroup;
                         $subject = $PNsubject;
                        echo $toEmail;

                      break;

                      case "IT":
                        $toEmail=$ITEmailGroup;
                         $subject = $PNsubject;
                        echo $toEmail;

                      break;

                  }
                }




                  // $adminEmail = "sameer.patwa@strhouston.com";
                  // $partsEmail = "";
                  // $ServiceEmail = "";

                //   $pnEmail = array("ADMIN"      =>  "saquib.test@strhouston.com",
                //                     "PARTS"     =>  "saquib.patwa@strhouston.com",
                //                     "SERVICE"   =>  "saquib.patwa@strhouston.com",
                //                     "BODYSHOP"  =>  "saquib.patwa@strhouston.com",
                //                     "IT"        =>  "saquib.patwa@strhouston.com",
                //                     "HR"        =>  "saquib.patwa@strhouston.com"
                //             );
                //
                // asort($pnEmail) ;
                // foreach($pnEmail as $DeptEmail => $recipientEmail)
                // {
                //
                //   $toEmail=$pnEmail;
                //   echo "The department $DeptEmail is sent to $recipientEmail"."\n" ;
                // }
                //
                // echo $toEmail;



                  // if (isset($_SESSION["department"])) {
                  //        switch ($_SESSION["department"]) {
                  //
                  //            // case: can use either name or id of the button
                  //           case 'ADMIN':
                  //                    $toEmail=$pnEmail;
                  //                        // echo $toEmail;
                  //                        $subject = $PNsubject;
                  //                        // echo $subject;
                  //           break;
                  //        }
                  //    }
                  //





                  //this uses the button name
                  // if (isset($_POST['submit2'])) {
                  //        switch ($_POST['submit2']) {
                  //
                  //            // case: can use either name or id of the button
                  //           case 'submit2':
                  //                    $toEmail=$pnEmail;
                  //                        // echo $toEmail;
                  //                        $subject = $PNsubject;
                  //                        // echo $subject;
                  //         break;
                  //        }
                  //    }


                 // $fromName = $_POST['first_name'] . " " . $_POST['last_name'] ;
                 $fromName = $_SESSION['user'];
                 // print_r ($fromName);

                 $from = $from_email; //submitter

                 // $from = "saquib.patwa@strhouston.com";
                 // required
                 // $phone = $_POST['phone'];
                 // $subject =$_POST['subject'];


// ITEmailGroup
// HREmailGroup


    if ($toEmail === $ITEmailGroup){
      $personnelNoticeList = array('first_name', 'last_name', 'effective_date', 'branch', 'department', 'employeeID', 'address', 'city', 'state', 'zip', 'telephone');

      // New Hire Section Array
      $newhireList= array('Hire_Reason', 'replacement_for', 'employment_Status', 'state_Issued', 'gender', 'ethnic_Code', 'marital_Status', 'job_Title', 'bonus_Commission_Plan', 'bonus_Level', 'other', 'New_Hire_Remarks');

      // Change Section Array
      $changeList= array('Job_Title_From', 'Job_Title_To', 'From_Branch', 'To_Branch', 'From_Department', 'To_Department', 'From_Employee_Status', 'To_Employee_Status', 'Change_Remarks');

      // Separation Section Array
      $separationList=array('Hire_Date', 'Last_Day_Worked', 'Separation_Date', 'Separation_Type', 'Separation_Reason', 'Eligible_to_Rehire', 'forward_emails', 'forwarding_to_employee_name', 'Separation_Remarks');


    }


    else if ($toEmail === $HREmailGroup){






     $error_message = "";
     $email_exp = '/^[A-Za-z0-9._%-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,4}$/';

     //color variable defined for the alternative colors
     $c=0;

     // 4 Array lists of input field name
     // General Contact Info Array
     $personnelNoticeList = array('first_name', 'last_name', 'effective_date', 'branch', 'department', 'employeeID', 'address', 'city', 'state', 'zip', 'telephone');

     // New Hire Section Array
     $newhireList= array('Hire_Reason', 'replacement_for', 'employment_Status', 'drivers_Licence', 'state_Issued', 'date_of_Birth', 'gender', 'ethnic_Code', 'marital_Status', 'job_Title', 'starting_Rate', 'per', 'bonus_Commission_Plan', 'bonus_Level', 'other', 'New_Hire_Remarks');

     // Change Section Array
     $changeList= array('Job_Title_From', 'Job_Title_To', 'Pay_From', 'Pay_From_Per', 'Pay_To', 'Pay_To_Per', 'From_Branch', 'To_Branch', 'From_Department', 'To_Department', 'From_Employee_Status', 'To_Employee_Status', 'Change_Remarks');

     // Separation Section Array
     $separationList=array('Hire_Date', 'Last_Day_Worked', 'Separation_Date', 'Separation_Type', 'Separation_Reason', 'Eligible_to_Rehire', 'forward_emails', 'forwarding_to_employee_name', 'Separation_Remarks');



      $email_message =  '<table rules="all" style="border-color: #666; font-family: Montserrat-Regular; font-size:14px; border-radius:7px 7px 0 0" cellpadding="10">';
      $email_message .= '<tr style="background: #fff"><td colspan="2" align="center"><img src="http://www.selectransportation.com/helpdesk/Images/STR-LOGO1.png"></td></tr>';
      $email_message .= '<tr style="background: #000000; color:#fff; border-radius: 8px 8px 0 0"><td colspan="2" align="center"><h3>' . strip_tags($subject) .'</h3></td></tr>';

      // $email_message .= '<thead><tr><th>title</td><td>price</td><td>number</td></tr></thead>';

      // GENERAL INFO SECTION
     foreach ($personnelNoticeList as $key) {
       if(isset($_POST[$key]) && $_POST[$key] != ''){

           // Adds alternate colors to the table rows
           $colour = ($c++ % 2 == 0) ? '#ffffff' : '#f3f3f3';
           // $colorOne = '#ffffff';
           // $colorTwo = '#f3f3f3';
           // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
           // $rowCount++;

           // email Body
           $email_message .= '<tr bgcolor="' . $colour . '">';
           $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
           $email_message .= '<td>'. wordwrap(htmlspecialchars($_POST[$key], ENT_QUOTES),75, "<br />\n") .'</td>';
           $email_message .= '</tr>';
         }
      }

    $email_message .= '<tr style="background: #000000; color:#fff;"><td colspan="2" align="center" id="NewHireEmailTitle"><h3>'. $_POST['personnelOnly'] . '</h3></td></tr>';
    foreach ($newhireList as $key) {
          if(isset($_POST[$key]) && $_POST[$key] != ''){

            // Adds alternate colors to the table rows
            $colour = ($c++ % 2 == 0) ? '#ffffff' : '#f3f3f3';
            // $colorOne = '#ffffff';
            // $colorTwo = '#f3f3f3';
            // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
            // $rowCount++;

            // email Body
            $email_message .= '<tr bgcolor="' . $colour . '">';
            $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
            $email_message .= '<td style="text-align:justify">'. wordwrap(htmlspecialchars($_POST[$key], ENT_QUOTES),75, "<br />\n") .'</td>';
            $email_message .= '</tr>';
          }
       }

   // $email_message .= '<tr style="background: #000000; color:#fff; display:block"><td colspan="2" align="center" id="ChangeEmailTitle"><h3>'. $ChangeEmailTitle . '</h3></td></tr>';
   foreach ($changeList as $key) {
             if(isset($_POST[$key]) && $_POST[$key] != ''){

               // Adds alternate colors to the table rows
               $colour = ($c++ % 2 == 0) ? '#ffffff' : '#f3f3f3';
               // $colorOne = '#ffffff';
               // $colorTwo = '#f3f3f3';
               // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
               // $rowCount++;

               // email Body
               $email_message .= '<tr bgcolor="' . $colour . '">';
               $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
               $email_message .= '<td style="text-align:justify">'. wordwrap(htmlspecialchars($_POST[$key], ENT_QUOTES),75, "<br />\n") .'</td>';
               $email_message .= '</tr>';
          }
      }

  // $email_message .= '<tr style="background: #000000; color:#fff; display:block"><td colspan="2" align="center" id="SeparationEmailTitle"><h3>'. $SeparationEmailTitle . '</h3></td></tr>';
  foreach ($separationList as $key) {
          if(isset($_POST[$key]) && $_POST[$key] != ''){

              // Adds alternate colors to the table rows
              $colour = ($c++ % 2 == 0) ? '#ffffff' : '#f3f3f3';
              // $colorOne = '#ffffff';
              // $colorTwo = '#f3f3f3';
              // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
              // $rowCount++;

              // email Body
              $email_message .= '<tr bgcolor="' . $colour . '">';
              $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
              $email_message .= '<td style="text-align:justify">'. wordwrap(htmlspecialchars($_POST[$key], ENT_QUOTES),75, "<br />\n") .'</td>';
              $email_message .= '</tr>';
          }
      }
        // $email_message .= '</table>';


        $email_message .= "<tr style='background: #000000; color:#fff; border-radius: 8px 8px 0 0'><td colspan='2' align='center'>Copyright &copy STR HelpDesk. All Rights Reserved.</td></tr>";



        // write query for all pizzas
// $sql = 'SELECT newhire_ID FROM PAN_newhires ORDER BY newhire_ID';
//
// // get the result set (set of rows)
// $result = mysqli_query($conn, $sql);
//
// // fetch the resulting rows as an array pizza
// $singleRecord = mysqli_fetch_all($result, MYSQLI_ASSOC);
//
// // free the $result from memory (good practise)
// mysqli_free_result($result);

// close connection
// mysqli_close($conn);




              $email_message .= '<tr bgcolor="#ccc">';
              // $email_message .= '<td><a href=https://selectransportation.com/hdesk/helpdesk/approval.php?newhireID='. $row['newhire_ID'] .'>Approve</a></td>';
              $email_message .= '<td><a href="https://selectransportation.com/hdesk/helpdesk/approve.php?newhireID=' . $id . '">Approve/Reject</a></td>'; //https://domain.com/action.php?id=27
              $email_message .= '</tr>';








        $email_message .= "</table>";
        $email_message .= "</body></html>";







        //
        //
        // $conn = OpenCon();
        //
        // if (!$conn) {
        //   die("Connection failed: " . $conn->connect_error);
        // }
        //
        // else{




        // }




}
// End of else statement of IT/HR email if else statement above



                 // Header for sender info
                 $headers = "From: $fromName"." <".$from.">";

                 if(!empty($uploadedFile) && file_exists($uploadedFile)){

                     // Boundary
                     $semi_rand = md5(time());
                     $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";

                     // Headers for attachment
                     $headers .= "\nMIME-Version: 1.0\n" . "Content-Type: multipart/mixed;\n" . " boundary=\"{$mime_boundary}\"";

                     // Multipart boundary
                     $message = "--{$mime_boundary}\n" . "Content-Type: text/html; charset=\"UTF-8\"\n" .
                     "Content-Transfer-Encoding: 7bit\n\n" . $email_message . "\n\n";

                     // Preparing attachment
                     if(is_file($uploadedFile)){
                         $message .= "--{$mime_boundary}\n";
                         $fp =    @fopen($uploadedFile,"rb");
                         $data =  @fread($fp,filesize($uploadedFile));
                         @fclose($fp);
                         $data = chunk_split(base64_encode($data));
                         $message .= "Content-Type: application/octet-stream; name=\"".basename($uploadedFile)."\"\n" .
                         "Content-Description: ".basename($uploadedFile)."\n" .
                         "Content-Disposition: attachment;\n" . " filename=\"".basename($uploadedFile)."\"; size=".filesize($uploadedFile).";\n" .
                         "Content-Transfer-Encoding: base64\n\n" . $data . "\n\n";
                     }

                     $message .= "--{$mime_boundary}--";
                     $returnpath = "-f" . $from;

                     // Send email
                     $mail = mail($toEmail, $subject, $message, $headers, $returnpath);

                     // Delete attachment file from the server
                     @unlink($uploadedFile);
                 }else{
                      // Set content-type header for sending HTML email
                     $headers .= "\r\n". "MIME-Version: 1.0";
                     $headers .= "\r\n". "Content-type:text/html;charset=UTF-8";
                     // $headers .= "\r\n"."From: saquib.patwa@strhouston.com" . "\r\n" ."CC: saquib.patwa@strhouston.com";
                     // $headers .= "\r\n". "cc: saquib.test@houstonfreightliner.com"; #Your BCC Mail List
                      $headers .= "\r\n". "Cc: " . $from .  "\r\n"; #Your BCC Mail List
                      // $headers .= "\r\n". "Bcc: saquib.test@strhouston.com"; #Your BCC Mail List

                      // $headers.="Bcc: ".implode(", ",$from_email)."\r\n";  // blind carbon copy all emails
                      // $headers .= "Cc: " . implode(", ", ['$from', $from_email]) .  "\r\n"; #Your BCC Mail List

                     // Send email
                     $mail = mail($toEmail, $subject, $email_message, $headers);
                 }

                 // If mail sent
                 if($mail){

                     // header("location: success.php");
                     // echo '<script type="text/javascript"> location.replace("../helpdesk/success.php","_self");</script>';
                     // echo "<script> success(); </script>";

                     // echo '<div style="text-align:center"></div>';
                     // $gourl='http://webdev/wordpress/ITHelpDesk/';
                     // echo '<META HTTP-EQUIV="Refresh" Content="5; URL='.$gourl.'">';
                     // exit;

                     // $statusMsg = 'Your request has been submitted successfully. We will be in touch with you soon. Thank You!';
                     // $msgClass = 'succdiv';

                     // $postData1 = '';
                 }else{
                     $statusMsg = '<br />Your request submission failed, please try again.';
                 }
             }
         }
     }else{
         $statusMsg = 'Please fill all the required fields.';

     }
 }









 ?>

 <!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1" />
    <meta name="viewport" content="width=device-width, initial-scale=1">

           <title>STR Help Desk</title>

           <!--===============================================================================================-->
               <!-- Favicon -->
               <!-- <link rel="icon" type="image/png" href="../helpdesk/Images/icons/help.ico"/> -->
           <!--===============================================================================================-->
               <!-- Bootstrap CSS -->
               <link rel="stylesheet" type="text/css" href="/hdesk/helpdesk/vendor/bootstrap/css/bootstrap.min.css">
               <link href="/hdesk/helpdesk/css/bootstrap_v3.2.0.css" rel="stylesheet" type="text/css" />
           <!--===============================================================================================-->
               <!-- Font Awesome -->
               <link rel="stylesheet" type="text/css" href="/hdesk/helpdesk/fonts/font-awesome-4.7.0/css/font-awesome.min.css">
               <!-- <link rel="stylesheet" href="path/to/font-awesome/css/font-awesome.min.css"> -->

           <!--===============================================================================================-->
               <!-- Fonts -->
               <link rel="stylesheet" type="text/css" href="/hdesk/helpdesk/css/util.css">
               <!-- Main CSS -->
               <link rel="stylesheet" type="text/css" href="/hdesk/helpdesk/css/main.css">
               <!-- forms and Buttons -->
               <link rel="stylesheet" type="text/css" href="/hdesk/helpdesk/css/misc.css">
           <!--===============================================================================================-->

           <!--===============================================================================================-->
            <!-- This is to create an App Icon when you save to you website to your homescreen.
                 Use the website www.favicon-generator.org/ to create an app icon and the code from the same website -->

                <link rel="apple-touch-icon" sizes="57x57" href="../helpdesk/Images/icons/Icons/apple-icon-57x57.png">
                <link rel="apple-touch-icon" sizes="60x60" href="../helpdesk/Images/icons/Icons/apple-icon-60x60.png">
                <link rel="apple-touch-icon" sizes="72x72" href="../helpdesk/Images/icons/Icons/apple-icon-72x72.png">
                <link rel="apple-touch-icon" sizes="76x76" href="../helpdesk/Images/icons/Icons/apple-icon-76x76.png">
                <link rel="apple-touch-icon" sizes="114x114" href="../helpdesk/Images/icons/Icons/apple-icon-114x114.png">
                <link rel="apple-touch-icon" sizes="120x120" href="../helpdesk/Images/icons/Icons/apple-icon-120x120.png">
                <link rel="apple-touch-icon" sizes="144x144" href="../helpdesk/Images/icons/Icons/apple-icon-144x144.png">
                <link rel="apple-touch-icon" sizes="152x152" href="../helpdesk/Images/icons/Icons/apple-icon-152x152.png">
                <link rel="apple-touch-icon" sizes="180x180" href="../helpdesk/Images/icons/Icons/apple-icon-180x180.png">
                <link rel="icon" type="image/png" sizes="192x192"  href="../helpdesk/Images/icons/Icons/android-icon-192x192.png">
                <link rel="icon" type="image/png" sizes="32x32" href="../helpdesk/Images/icons/Icons/favicon-32x32.png">
                <link rel="icon" type="image/png" sizes="96x96" href="../helpdesk/Images/icons/Icons/favicon-96x96.png">
                <link rel="icon" type="image/png" sizes="16x16" href="../helpdesk/Images/icons/Icons/favicon-16x16.png">
                <link rel="mask-icon" href="../helpdesk/Images/icons/Icons/safari-pinned-tab.svg" color="#5bbad5">
                <link rel="manifest" href="../helpdesk/Images/icons/Icons/manifest.json">
                <meta name="msapplication-TileColor" content="#ffffff">
                <meta name="msapplication-TileImage" content="../helpdesk/Images/icons/Icons/ms-icon-144x144.png">
                <meta name="theme-color" content="#ffffff">

            <!--===============================================================================================-->

               <!-- JQuery -->
               <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
           <!--===============================================================================================-->

              <!-- <script src="//code.jquery.com/jquery.min.js"></script> -->
              <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
              <!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> -->




      </head>

      <body class="contact1">
        <!-- centering the entire div -->
        <div align="center" style="margin:auto">

        <!-- logo -->
        <div class="contact1 logo"><img src="../helpdesk/Images/STR-Logo-Med2.png" class="logo" /></div> <br>
        <h3>I NEED HELP FROM</h3><br>



        <button id="DivIdToScroll3" type="button" class="btn success showSingle" target="2"   data-toggle="modal" data-target="#loginModal"  onclick="HideContainerOne(); ">
          PERSONNEL<br />ACTION NOTICE
      </button>



     <div id="scroll_div">







<?php
// session_start();
if(isset($_SESSION['user']))
{
  // echo '<script>';
  // echo '("#loginModal").modal("hide")';
  // echo '</script>';



?>


<div id="container-contact2"  class="container-contact2">
  <!-- <button class="close" onclick="document.getElementById('container-contact2').style.display='none'" id="formclose1">X</button> -->

<div class="container">
  <div class="row">
    <div class="col-6" align="center">
      <?php


    // Getting the job titles from DB
    $job_Title = $_SESSION['job_Title'];

    // $department = $_SESSION["department"];

     // $array = $_SESSION['array'];
     // print_r($array);
    // print_r($job_Title);

    // Define recursive function to extract nested values
     function printValues($job_Title) {
         global $count;
         global $values;

         // Check input is an array
         if(!is_array($job_Title)){
             die("ERROR: Input is not an array");
         }

         /*
         Loop through array, if value is itself an array recursively call the
         function else add the value found to the output items array,
         and increment counter by 1 for each value found
         */
         foreach($job_Title as $key=>$value){
             if(is_array($value)){
                 printValues($value);
             } else{
                 $values[] = $value;
                 $count++;
             }
         }

         // Return total count and values found in array
         // return array('total' => $count, 'values' => $values);
         return array('values' => $values);

     }


     // Call the function and print all the values
     $result = printValues($job_Title);
     $job_Title = $result;

     // echo "<h3>" . $result["total"] . " value(s) found: </h3>";
     // echo implode("<br>", $job_Title["values"]);



     $sql = "SHOW TABLE STATUS LIKE 'table'";
     $result=$conn->query($sql);
     $row = $result->fetch_assoc();

     echo $row['Auto_increment'];






       ?>

       <!-- . " " .$department -->
      <p class="loginName">HOWDY!! &nbsp;<?php echo $_SESSION['user']; ?></p><br />

          <!-- <?php   echo "this is ".  $row['Auto_increment']; ?> -->
    </div>
    <div class="col-6" align="right">
      <a href="../helpdesk/logout.php" class="logoutbtn successLogout" name="logout" id="logout">LOGOUT</a>
    </div>
  </div>
</div>


  <div  id="div2" class="targetDiv" align="center">



<?php
// $img = mysqli_query($conn, "SELECT * FROM PAN_newhires");
//      while ($row = mysqli_fetch_array($img)) {
//
//       	// echo "<img src='https://selectransportation.com/hdesk/helpdesk/uploads/".$row['Attachment']."' height='200px' width='200px'>";
//
//
//     }
//
// ?>



<?php
// while ($row = mysqli_fetch_array($result)) {
//       echo "<div id='img_div'>";
//       	echo "<img src='uploads/".$row['Attachment']."' >";
//       	// echo "<p>".$row['image_text']."</p>";
//       echo "</div>";
//     }




?>
<!-- <img src="source.php?newhire_ID=1" width="300" height="300" /> -->
     <!-- <h6>HOWDY!! - <?php echo $_SESSION['user']; ?> &nbsp;&nbsp; | &nbsp;&nbsp; <a href="logout.php" id="logout">Logout</a></h6> -->

                           <form  id="form2" class="contact2-form needs-validation" novalidate="novalidate" method="post" action="" enctype="multipart/form-data" >

                             <?php

                             include_once "db_connection.php";

                             $newhireID = mysqli_real_escape_string($conn,$_GET['newhireID']);

                             $showQuery = "SELECT * FROM PAN_newhires WHERE newhireID = '$newhireID'";

                             $showData = mysqli_query($conn, $showQuery);

                             $arrData = mysqli_fetch_array($showData);

                             if (isset($_POST['submit2'])){

                               $UpdateID = mysqli_real_escape_string($conn,$_GET['newhireID']);

                               $id = mysqli_real_escape_string($conn,$_POST['newhire_ID']);
                               $first_name = mysqli_real_escape_string($conn,$_POST['first_name']);
                               $last_name = mysqli_real_escape_string($conn,$_POST['last_name']);
                               $effective_date = mysqli_real_escape_string($conn,$_POST['effective_date']);
                               // $effective_date = date("d-m-Y", strtotime($_POST['effective_date']));
                               $branch = mysqli_real_escape_string($conn,$_POST['branch']);
                               $department = mysqli_real_escape_string($conn,$_POST['department']);
                               $employeeID = mysqli_real_escape_string($conn,$_POST['employeeID']);
                               $address= mysqli_real_escape_string($conn,$_POST['address']);
                               $city = mysqli_real_escape_string($conn,$_POST['city']);
                               $state = mysqli_real_escape_string($conn,$_POST['state']);
                               $zip = mysqli_real_escape_string($conn,$_POST['zip']);
                               $telephone = mysqli_real_escape_string($conn,$_POST['telephone']);
                               $from_email = mysqli_real_escape_string($conn,$_SESSION['from_email']);
                               $attachment = mysqli_real_escape_string($conn,$_POST['fileName']);
                               // $_SESSION['Department'] = htmlentities($_POST['email']);

                               // New Hire Section
                               $Hire_Reason = mysqli_real_escape_string($conn,$_POST['Hire_Reason']);
                               $replacement_for = mysqli_real_escape_string($conn,$_POST['replacement_for']);
                               $employment_Status = mysqli_real_escape_string($conn,$_POST['employment_Status']);
                               $drivers_Licence = mysqli_real_escape_string($conn,$_POST['drivers_Licence']);
                               $state_Issued = mysqli_real_escape_string($conn,$_POST['state_Issued']);
                               $date_of_Birth = mysqli_real_escape_string($conn,$_POST['date_of_Birth']);
                               $gender = mysqli_real_escape_string($conn,$_POST['gender']);
                               $ethnic_Code = mysqli_real_escape_string($conn,$_POST['ethnic_Code']);
                               $marital_Status = mysqli_real_escape_string($conn,$_POST['marital_Status']);
                               // $job_Title = implode(', ',array_keys($_SESSION['job_Title']));
                               $job_Title = $_SESSION['job_Title'];
                               $job_Title = mysqli_real_escape_string($conn,$_POST['job_Title']);
                               $starting_Rate = mysqli_real_escape_string($conn,$_POST['starting_Rate']);
                               $per = mysqli_real_escape_string($conn,$_POST['per']);
                               $bonus_Commission_Plan = mysqli_real_escape_string($conn,$_POST['bonus_Commission_Plan']);
                               $bonus_Level = mysqli_real_escape_string($conn,$_POST['bonus_Level']);
                               $other = mysqli_real_escape_string($conn,$_POST['other']);
                               $New_Hire_Remarks = mysqli_real_escape_string($conn,$_POST['New_Hire_Remarks']);




                               // $query= "INSERT INTO
                               //   PAN_newhires (
                               //     first_name,
                               //     last_name,
                               //     effective_date,
                               //     branch,
                               //     department,
                               //     address,
                               //     city,
                               //     state,
                               //     zip,
                               //     telephone,
                               //     Hire_Reason,
                               //     replacement_for,
                               //     employment_Status,
                               //     drivers_Licence,
                               //     state_Issued,
                               //     date_of_Birth,
                               //     gender,
                               //     ethnic_Code,
                               //     marital_Status,
                               //     job_Title,
                               //     starting_Rate,
                               //     per,
                               //     bonus_Commission_Plan,
                               //     bonus_Level,
                               //     other,
                               //     New_Hire_Remarks,
                               //     Attachment
                               //   )
                               // VALUES(
                               //     '$first_name',
                               //     '$last_name',
                               //     '$effective_date',
                               //     '$branch',
                               //     '$department',
                               //     '$address',
                               //     '$city',
                               //     '$state',
                               //     '$zip',
                               //     '$telephone',
                               //     '$Hire_Reason',
                               //     '$replacement_for',
                               //     '$employment_Status',
                               //     '$drivers_Licence',
                               //     '$state_Issued',
                               //     '$date_of_Birth',
                               //     '$gender',
                               //     '$ethnic_Code',
                               //     '$marital_Status',
                               //     '$job_Title',
                               //     '$starting_Rate',
                               //     '$per',
                               //     '$bonus_Commission_Plan',
                               //     '$bonus_Level',
                               //     '$other',
                               //     '$New_Hire_Remarks',
                               //     '$fileName'
                               //   )";



                                 $UpdateQuery= "UPDATE
                                   PAN_newhires SET
                                     first_name = '$first_name',
                                     last_name = '$last_name',
                                     effective_date = '$effective_date',
                                     branch = '$branch',
                                     department = '$department',
                                     address = '$address',
                                     city = '$city',
                                     state = '$state',
                                     zip = '$zip',
                                     telephone = '$telephone',
                                     Hire_Reason = '$Hire_Reason',
                                     replacement_for = '$replacement_for',
                                     employment_Status = '$employment_Status',
                                     drivers_Licence = '$drivers_Licence',
                                     state_Issued = '$state_Issued',
                                     date_of_Birth = '$date_of_Birth',
                                     gender = '$gender',
                                     ethnic_Code = '$ethnic_Code',
                                     marital_Status = '$marital_Status',
                                     job_Title = '$job_Title',
                                     starting_Rate = '$starting_Rate',
                                     per = '$per',
                                     bonus_Commission_Plan = '$bonus_Commission_Plan',
                                     bonus_Level = '$bonus_Level',
                                     other = '$other',
                                     New_Hire_Remarks = '$New_Hire_Remarks',
                                     Attachment = '$fileName' WHERE newhireID = '$UpdateID'";



                                   $res = mysqli_query($conn, $UpdateQuery)


                                   if ($res){
                                     ?>
                                     <script>
                                        alert("data updated properly");
                                      </script>
                                    <?php
                                  }else{
                                    ?>
                                    <script>
                                       alert("data not updated");
                                     </script>
                                    <?php
                                  }
                                }











                                 // mysql_select_db('PAN');
                                 // $db_select = mysqli_select_db($conn, DB_NAME);


                                 // if ($conn->query($query) === TRUE) {
                                 //   echo "New record created successfully";
                                 // } else {
                                 //   echo "Error: " . $query . "<br>" . $conn->error;
                                 // }



                               //Get the auto-increment id value
                               // $id = mysqli_insert_id($conn);


                             // }



                              ?>



                            <span class="contact2-form-title">PERSONNEL ACTION NOTICE</span><br /><span class="contact2-form-title-confidential"> CONFIDENTIAL</span><br /><br />

                            <div id="EmpOrCust">
                              <h4 align="center">What would you like to do? </h4>

                              <div class="row">
                                <div class="container-fluid" align="center">
                                    <div class="form-check form-check-inline">
                                      <input class="form-check-input" type="radio" onclick="javascript:PersonnelEmpCheck();" name="personnelOnly" id="newhire" value="NEW HIRE" class="newhire" required>
                                      <label class="form-check-label NewHireCheckboxTitle" for="newhire">NEW HIRE</label>
                                    </div>

                                    <div class="form-check form-check-inline">
                                      <input class="form-check-input" type="radio" onclick="javascript:PersonnelEmpCheck();" name="personnelOnly"  id="change"   value="CHANGE" class="change" required>
                                      <label class="form-check-label" for="change">CHANGE</label>
                                    </div>

                                    <div class="form-check form-check-inline">
                                      <input class="form-check-input" type="radio" onclick="javascript:PersonnelEmpCheck();" name="personnelOnly"  id="separation" value="SEPARATION" class="separation" required>
                                      <label class="form-check-label" for="separation">SEPARATION</label>
                                    </div>

                                </div>
                              </div>
                        <br />



                          <!-- General Info -->


                            <div class="row">  <!--Date  pattern="\d{1,2}/\d{1,2}/\d{4}" -->
                                <div class="wrap-input1 validate-input col-md-6  date" data-validate = "Date is required" data-provide="datepicker" data-date-format="yyyy/mm/dd">
                                  <input class="form-control input1 date-withicon" type="text"  name="effective_date"   placeholder="Effective Date"  value="<?php echo !empty($res['effective_date'])?$res['effective_date']:''; ?>"    required>
                                  <div class="input-group-addon"></div>
                                </div>

                                 <div class="wrap-input1 validate-input col-md-6" data-validate = "Employee ID is required">
                                    <input class="form-control input1" type="text" name="employeeID"  id="employeeID"  onkeypress="return isNumberKey(event)"  pattern="[0-9]*"  value="<?php echo !empty($res['employeeID'])?$res['employeeID']:''; ?>" placeholder="Employee ID"   required>
                                    <span class="shadow-input1"></span>
                                </div>
                            </div>


                            <div class="row">
                                <div class="wrap-input1 validate-input col-md-6" data-validate = "First Name is required">
                                    <input class="form-control input1" type="text" name="first_name"  value="<?php echo !empty($res['first_name'])?$res['first_name']:''; ?>" placeholder="First Name"   required>
                                    <span class="shadow-input1"></span>
                                </div>

                                <div class="wrap-input1 validate-input col-md-6" data-validate = "Last Name is required">
                                    <input class="form-control input1" type="text" name="last_name"  value="<?php echo !empty($res['last_name'])?$res['last_name']:''; ?>" placeholder="Last Name"   required>
                                    <span class="shadow-input1"></span>
                                </div>
                            </div>

                            <div class="row">
                                <div class="wrap-input1 validate-input col-md-6" data-validate = "Branch is required">
                                      <select id="branch" name="branch"  class="browser-default form-select input1"   required >
                                        <option value="">Branch</option>
                                        <option value="010-HFI">010-HFI</option>
                                        <option value="017-HDTP">017-HDTP</option>
                                        <option value="020-CCFI">020-CCFI</option>
                                        <option value="030-BMT">030-BMT</option>
                                        <option value="060-TBGC">060-TBGC</option>
                                        <option value="080-STR">080-STR</option>
                                        <option value="090-STC">090-STC</option>
                                      </select>
                                </div>

                                <div class="wrap-input1 validate-input col-md-6"   data-validate = "Department is required">
                                      <select  name="department"   class="browser-default form-select input1"     required>
                                        <option value="">Department</option>

                                       <!-- <?php
                                          sort($department);
                                          ?>
                                            <option value="<?= ucwords(strtolower($department)); ?>"><?= ucwords(strtolower($department)); ?></option>
                                        <?php
                                           ?> -->


                                        <option value="New Truck">New Truck</option>
                                        <option value="Used Truck">Used Truck</option>
                                        <option value="Parts">Parts</option>
                                        <option value="Service">Service</option>
                                        <option value="Body Shop">Body Shop</option>
                                        <option value="Accounting">Accounting</option>
                                        <option value="Administration">Administration</option>
                                        <option value="IT">IT</option>
                                      </select>
                                </div>
                            </div>



                            <div class="row">
                                <div class="wrap-input1 validate-input col-md-6"   data-validate = "Address is required"  id="address">
                                     <input type="text" class="form-control input1" name="address"   placeholder="Address" value="<?php echo !empty($res['address'])?$res['address']:''; ?>"   required>
                                </div>

                                 <div class="wrap-input1 validate-input col-md-6" data-validate = "City is required" id="city">
                                      <input type="text" class="form-control input1" name="city"   placeholder="City" value="<?php echo !empty($res['city'])?$res['city']:''; ?>"   required>
                                 </div>
                            </div>


                            <div class="row">
                                <div class="wrap-input1 validate-input col-md-6"   data-validate = "State is required" id="state">
                                  <select name="state"  class="browser-default form-select input1"   required>
                                    <option value="">State</option>
                                    <option value="AK">Alaska</option>
                                    <option value="AL">Alabama</option>
                                    <option value="AR">Arkansas</option>
                                    <option value="AZ">Arizona</option>
                                    <option value="CA">California</option>
                                    <option value="CO">Colorado</option>
                                    <option value="CT">Connecticut</option>
                                    <option value="DC">District of Columbia</option>
                                    <option value="DE">Delaware</option>
                                    <option value="FL">Florida</option>
                                    <option value="GA">Georgia</option>
                                    <option value="HI">Hawaii</option>
                                    <option value="IA">Iowa</option>
                                    <option value="ID">Idaho</option>
                                    <option value="IL">Illinois</option>
                                    <option value="IN">Indiana</option>
                                    <option value="KS">Kansas</option>
                                    <option value="KY">Kentucky</option>
                                    <option value="LA">Louisiana</option>
                                    <option value="MA">Massachusetts</option>
                                    <option value="MD">Maryland</option>
                                    <option value="ME">Maine</option>
                                    <option value="MI">Michigan</option>
                                    <option value="MN">Minnesota</option>
                                    <option value="MO">Missouri</option>
                                    <option value="MS">Mississippi</option>
                                    <option value="MT">Montana</option>
                                    <option value="NC">North Carolina</option>
                                    <option value="ND">North Dakota</option>
                                    <option value="NE">Nebraska</option>
                                    <option value="NH">New Hampshire</option>
                                    <option value="NJ">New Jersey</option>
                                    <option value="NM">New Mexico</option>
                                    <option value="NV">Nevada</option>
                                    <option value="NY">New York</option>
                                    <option value="OH">Ohio</option>
                                    <option value="OK">Oklahoma</option>
                                    <option value="OR">Oregon</option>
                                    <option value="PA">Pennsylvania</option>
                                    <option value="PR">Puerto Rico</option>
                                    <option value="RI">Rhode Island</option>
                                    <option value="SC">South Carolina</option>
                                    <option value="SD">South Dakota</option>
                                    <option value="TN">Tennessee</option>
                                    <option value="TX">Texas</option>
                                    <option value="UT">Utah</option>
                                    <option value="VA">Virginia</option>
                                    <option value="VT">Vermont</option>
                                    <option value="WA">Washington</option>
                                    <option value="WI">Wisconsin</option>
                                    <option value="WV">West Virginia</option>
                                    <option value="WY">Wyoming</option>
                                  </select>
                                </div>


                                <div class="wrap-input1 validate-input col-md-6" data-validate = "5 Digit Zipcode is required"  id="zip">
                                    <!-- <label for="inputZip">Zip</label> -->
                                    <input type="text" class="form-control input1" name="zip"  onkeypress="return isNumberKey(event)"  placeholder="Zip Code" pattern="[0-9]*"  value="<?php echo !empty($res['zip'])?$res['zip']:''; ?>"   required>
                                </div>

                            </div>


                            <div class="row">
                                    <div class="wrap-input1 validate-input col-md-6" data-validate = "Phone No. is required" id="telephone">
                                        <input class="form-control input1" type="text"  name="telephone"   value="<?php echo !empty($res['telephone'])?$res['telephone']:''; ?>" placeholder="Telephone" onKeyup="formatPhone(this);" maxlength="12" pattern="^\D?(\d{3})\D?\D?(\d{3})\D?(\d{4})$"   required>
                                        <!-- <span class="shadow-input1"></span> -->
                                    </div>

                                    <!-- <div class="wrap-input1 validate-input col-md-6" data-validate = "Valid email is required: ex@abc.xyz">
                                        <input class="form-control input1" type="email" name="from_email" id="from_email" value="<?php echo !empty($res['from_email'])?$res['from_email']:''; ?>" pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$" placeholder="Email" required>
                                        <span class="shadow-input1"></span>
                                    </div> -->
                            </div>


                             <div class="row">
                               <div class="wrap-input1 col-md-12 form-group">
                                  <input type="file" name="attachment" class="form-control input1 attachments" multiple="multiple">
                              </div>
                             </div>

                         <br />


<!-- NEW HIRE SECTION -->
     <div id="newhireSection" style="display:none" class="row">

        <fieldset class="NewHireSection scheduler-border"><br />
            <legend class="scheduler-border">NEW HIRE</legend>
             <h6 style="margin-top:-10px">FILL OUT ALL INFORMATION FOR NEW HIRE SET UP</h6>

              <div class="row">
                  <div class="wrap-input1 validate-input col-md-6"   data-validate = "Hire Reason is required">
                        <select  name="Hire_Reason" id="Hire_Reason"   class="browser-default form-select input1"  >
                          <option value="">Hire Reason</option>
                          <option value="New Hire">New Hire</option>
                          <option value="Rehire">Rehire</option>
                          <option value="Replacement">Replacement For</option>
                        </select>
                  </div>

                  <div class="wrap-input1 validate-input col-md-6" >
                      <input class="form-control input1" type="text" name="replacement_for"  id="replacement_for" value="<?php echo !empty($res['replacement_for'])?$res['replacement_for']:''; ?>" placeholder="Replacement Name"  disabled>
                      <!-- <span class="shadow-input1"></span> -->
                  </div>
              </div>


              <div class="row">
                  <div class="wrap-input1 validate-input col-md-6"   data-validate = "Employment Status is required">
                        <select  name="employment_Status"  id="employment_Status" class="browser-default form-select input1"  >
                          <option value="">Employment Status</option>
                          <option value="Full-time Regular">Full-time Regular</option>
                          <option value="Full-time Temporary">Full-time Temporary</option>
                          <option value="Part-time Regular">Part-time Regular</option>
                          <option value="Part-time Temporary">Part-time Temporary</option>
                        </select>
                  </div>

                  <div class="wrap-input1 validate-input col-md-6"   data-validate = "Drivers Licence No. is required">
                       <input type="text" class="form-control input1" name="drivers_Licence"  id="drivers_Licence"  onkeypress="return isNumberKey(event)"  placeholder="Drivers Licence #" value="<?php echo !empty($res['drivers_Licence'])?$res['drivers_Licence']:''; ?>"   >
                  </div>
             </div>

             <div class="row">
                 <div class="wrap-input1 validate-input col-md-6" data-validate = "State of Issuance is required">
                   <select name="state_Issued"  id="state_Issued"  class="browser-default form-select input1"    >
                     <option value="">State of Issuance</option>
                     <option value="AK">Alaska</option>
                     <option value="AL">Alabama</option>
                     <option value="AR">Arkansas</option>
                     <option value="AZ">Arizona</option>
                     <option value="CA">California</option>
                     <option value="CO">Colorado</option>
                     <option value="CT">Connecticut</option>
                     <option value="DC">District of Columbia</option>
                     <option value="DE">Delaware</option>
                     <option value="FL">Florida</option>
                     <option value="GA">Georgia</option>
                     <option value="HI">Hawaii</option>
                     <option value="IA">Iowa</option>
                     <option value="ID">Idaho</option>
                     <option value="IL">Illinois</option>
                     <option value="IN">Indiana</option>
                     <option value="KS">Kansas</option>
                     <option value="KY">Kentucky</option>
                     <option value="LA">Louisiana</option>
                     <option value="MA">Massachusetts</option>
                     <option value="MD">Maryland</option>
                     <option value="ME">Maine</option>
                     <option value="MI">Michigan</option>
                     <option value="MN">Minnesota</option>
                     <option value="MO">Missouri</option>
                     <option value="MS">Mississippi</option>
                     <option value="MT">Montana</option>
                     <option value="NC">North Carolina</option>
                     <option value="ND">North Dakota</option>
                     <option value="NE">Nebraska</option>
                     <option value="NH">New Hampshire</option>
                     <option value="NJ">New Jersey</option>
                     <option value="NM">New Mexico</option>
                     <option value="NV">Nevada</option>
                     <option value="NY">New York</option>
                     <option value="OH">Ohio</option>
                     <option value="OK">Oklahoma</option>
                     <option value="OR">Oregon</option>
                     <option value="PA">Pennsylvania</option>
                     <option value="PR">Puerto Rico</option>
                     <option value="RI">Rhode Island</option>
                     <option value="SC">South Carolina</option>
                     <option value="SD">South Dakota</option>
                     <option value="TN">Tennessee</option>
                     <option value="TX">Texas</option>
                     <option value="UT">Utah</option>
                     <option value="VA">Virginia</option>
                     <option value="VT">Vermont</option>
                     <option value="WA">Washington</option>
                     <option value="WI">Wisconsin</option>
                     <option value="WV">West Virginia</option>
                     <option value="WY">Wyoming</option>
                   </select>
                 </div>

                 <div class="wrap-input1 validate-input col-md-6 date" data-validate = "DOB is required" data-provide="datepicker" data-date-format="yyyy/mm/dd">
                   <input class="form-control input1 date-withicon" type="text"  name="date_of_Birth"  id="date_of_Birth"   placeholder="DOB"  value="<?php echo !empty($res['date_of_Birth'])?$res['date_of_Birth']:''; ?>" >
                    <div class="input-group-addon"></div>
                 </div>

             </div>


             <div class="row">
                 <div class="wrap-input1 validate-input col-md-6"   data-validate = "Gender is required">

                       <select  name="gender"  id="gender"  class="browser-default form-select input1"  >
                         <option value="">Gender</option>
                         <option value="Male">Male</option>
                         <option value="Female">Female</option>
                       </select>
                 </div>

                 <div class="wrap-input1 validate-input col-md-6"   data-validate = "Ethnic Code is required">

                       <select  name="ethnic_Code"  id="ethnic_Code"  class="browser-default form-select input1"  >
                         <option value="">Ethnic Code</option>
                         <option value="American Indian or Alaskia">American Indian or Alaskia</option>
                         <option value="Asian">Asian</option>
                         <option value="Black">Black</option>
                         <option value="Hawaiian pacific isl">Hawaiian/Pacific Isl</option>
                         <option value="Hispanic Latino">Hispanic/Latino</option>
                         <option value="Multi">Multi</option>
                         <option value="Unknown">Unknown</option>
                         <option value="White/Caucasian">White/Caucasian</option>
                       </select>
                 </div>
            </div>


            <div class="row">
                <div class="wrap-input1 validate-input col-md-6"   data-validate = "Marital Status is required">

                      <select  name="marital_Status"  id="marital_Status"  class="browser-default form-select input1"  >
                        <option value="">Marital Status</option>
                        <option value="Divorced">Divorced</option>
                        <option value="Domestic Partner">Domestic Partner</option>
                        <option value="Married">Married</option>
                        <option value="Separated">Separated</option>
                        <option value="Single">Single</option>
                        <option value="Widowed">Widowed</option>
                        <option value="Unknown">Unknown</option>
                      </select>
                </div>

                <div class="wrap-input1 validate-input col-md-6"   data-validate = "Job Title is required">

                      <select  name="job_Title" id="job_Title"  class="browser-default form-select input1"  >

                        <option value="">Job Title</option>
                        <?php
                          sort($job_Title['values']);
                          foreach($job_Title['values'] as $Titles) { ?>
                            <option value="<?= ucwords(strtolower($Titles)); ?>"><?= ucwords(strtolower($Titles)); ?></option>
                        <?php
                          } ?>

                        <!-- <option value="Accounting Assistant">Accounting Assistant</option>
                        <option value="Accounts Payable">Accounts Payable</option>
                        <option value="Accounts Receivable">Accounts Receivable</option>
                        <option value="Administrative Clerk">Administrative Clerk</option>
                        <option value="Application Developer">Application Developer</option>
                        <option value="Apprentice">Apprentice</option>
                        <option value="Assistance Dispatcher">Assistance Dispatcher</option>
                        <option value="Assistant F & I Manager">Assistant F & I Manager</option>
                        <option value="Assistant Manager">Assistant Manager</option>
                        <option value="Assistant Warehouse Manager">Assistant Warehouse Manager</option>
                        <option value="Back Counter Sales">Back Counter Sales</option>
                        <option value="Body Shop Parts">Body Shop Parts</option>
                        <option value="Body Shop Parts - Exempt">Body Shop Parts - Exempt</option>
                        <option value="Body Shop Warehouse">Body Shop Warehouse</option>
                        <option value="BodyMan">BodyMan</option>
                        <option value="Cash Receipt Clerk">Cash Receipt Clerk</option>
                        <option value="Clerical">Clerical</option>
                        <option value="Contract Administrator">Contract Administrator</option>
                        <option value="Contract Maintenance">Contract Maintenance</option>
                        <option value="Controller">Controller</option>
                        <option value="Coordinator">Coordinator</option>
                        <option value="Core Management - Exempt">Multi</option>
                        <option value="Counsel">Counsel</option>
                        <option value="Customer Support Manager">Customer Support Manager</option>
                        <option value="Delivery Driver">Delivery Driver</option>
                        <option value="Estimator">Estimator</option>
                        <option value="F & I Manager">F & I Manager</option>
                        <option value="Facilities Assistant">Facilities Assistant</option>
                        <option value="Facilities Manager">Facilities Manager</option>
                        <option value="Fleet Sales Representative">Fleet Sales Representative</option>
                        <option value="Foreman">Foreman</option>
                        <option value="Front Counter Sales">Front Counter Sales</option>
                        <option value="General Manager">General Manager</option>
                        <option value="Human Resources Manager">Human Resources Manager</option>
                        <option value="Inventory Control">Inventory Control</option>
                        <option value="IT Assistant">IT Assistant</option>
                        <option value="Manager">Manager</option>
                        <option value="Network System Administrator">Network System Administrator</option>
                        <option value="Painter">Painter</option>
                        <option value="Parts Puller">Parts Puller</option>
                        <option value="PC Technician">PC Technician</option>
                        <option value="Phone Room Sales">Phone Room Sales</option>
                        <option value="Porter">Porter</option>
                        <option value="Receptionist">Receptionist</option>
                        <option value="Sales Coordinator">Sales Coordinator</option>
                        <option value="Sales Manager">Sales Manager</option>
                        <option value="Sales Representative - Parts">Sales Representative - Parts</option>
                        <option value="Sales Representative - Truck">Sales Representative - Truck</option>
                        <option value="Service Writer">Service Writer</option>
                        <option value="Shipping and Receiving">Shipping and Receiving</option>
                        <option value="Technician - Flat Rate">Technician - Flat Rate</option>
                        <option value="Technician - Hourly">Technician - Hourly</option>
                        <option value="Trainer">Trainer</option>
                        <option value="Warehouse">Warehouse</option>
                        <option value="Warehouse Manager">Warehouse Manager</option>
                        <option value="Warranty Coordinator">Warranty Coordinator</option>
                        <option value="Warranty Manager">Warranty Manager</option>
                        <option value="Wholesale">Wholesale</option>
                        <option value="Wholesale Manager">Wholesale Manager</option>
                        <option value="Will Call">Will Call</option> -->
                      </select>
                </div>
           </div>

           <div class="row">
               <div class="wrap-input1 validate-input col-md-6" data-validate = "Starting Rate is required">
                   <input type="text" class="form-control input1" name="starting_Rate"  id="starting_Rate" placeholder="Starting Rate" pattern="^\$\d{1,3}(,\d{3})*(\.\d+)?$"  data-type="currency"  value="<?php echo !empty($res['starting_Rate'])?$res['starting_Rate']:''; ?>"   >
               </div>

               <div class="wrap-input1 validate-input col-md-6"   data-validate = "Per is required">
                     <select  name="per"  id="per"  class="browser-default form-select input1" >
                       <option value="" disabled selected>Per</option>
                       <option value="Annum">Annum</option>
                       <option value="Hour">Hour</option>
                       <option value="Week">Week</option>
                     </select>
               </div>
          </div>

          <div class="row">
              <div class="wrap-input1 validate-input col-md-6"   data-validate = "Bonus/Commission is required">
                    <select  name="bonus_Commission_Plan" id="bonus_Commission_Plan"  class="browser-default form-select input1" >
                      <option value="" disabled selected>Bonus or Commission Plan ? </option>
                      <option value="Bonus">Bonus</option>
                      <option value="Commission">Commission</option>
                      <option value="Neither">Neither</option>
                    </select>
              </div>

              <div class="wrap-input1  col-md-6"   data-validate = "Bonus Level is required">
                    <select  name="bonus_Level"  id="bonus_Level"  class="browser-default form-select input1" >
                      <option value="" disabled selected>Bonus Level</option>
                      <option value="1">1</option>
                      <option value="2">2</option>
                      <option value="3">3</option>
                    </select>
                    <!-- <input hidden name="bonusLevel" value="None"/> -->
              </div>
         </div>

         <div class="row">
             <div class="wrap-input1 validate-input col-md-6" data-validate = "Other is required">
                 <input type="text" class="form-control input1" name="other" id="other"  placeholder="Other"  value="<?php echo !empty($res['other'])?$res['other']:''; ?>"   >
             </div>
        </div>

        <!-- Remarks -->
          <div class="wrap-input1 validate-input1" data-validate = "Remarks is required">
              <h6 style="margin-bottom:3px; text-transform: uppercase;">Use the remarks section below to note any specific usage rights or logins needed for this employee</h6>
              <textarea class="form-control input1" name="New_Hire_Remarks"   id="New_Hire_Remarks"  placeholder="Remarks"><?php echo !empty($postData['New_Hire_Remarks'])?$postData['New_Hire_Remarks']:''; ?></textarea>
              <span class="shadow-input1"></span>
          </div>


       </fieldset>

  </div><!-- END OF Newhire Section Div -->


  <!-- CHANGE SECTION -->
  <div id="changeSection" style="display:none" class="row">

    <!-- <div id="change"> -->
       <fieldset class="ChangeSection scheduler-border">
           <legend class="scheduler-border">CHANGE</legend>
           <h6 style="margin-top:-5px">CHECK THE APPLICABLE OPTIONS & EXPLAIN IN THE REMARKS SECTION IF NECESSARY</h6>

           <!-- JOB TITLE -->
          <div class="row">
               <div class="wrap-input1 validate-input col-md-4">
                  <input class="form-check-input1" type="checkbox" value="" id="jobTitleCheckbox" >
                  <label class="form-check-label" for="jobTitleCheckbox">Job Title</label>
               </div>


                <!-- <span style="margin:17px 0; font-weight:bold; color:#666">From:</span> -->
                 <div class="wrap-input1 validate-input col-md-4"   data-validate = "Job Title is required">
                   <!-- <label class="mdb-main-label">From:</label> -->
                   <label for="Job_Title_From">From:</label>
                       <select  name="Job_Title_From"  id="Job_Title_From" class="browser-default form-select input1"   disabled>
                         <option value="" disabled selected>Job Title</option>
                         <?php
                           foreach($job_Title['values'] as $JobTitles) { ?>
                             <option value="<?= ucwords(strtolower($JobTitles)); ?>"><?= ucwords(strtolower($JobTitles)); ?></option>
                           <?php
                             } ?>

                         <!-- <option value="Accounting Assistant">Accounting Assistant</option>
                         <option value="Accounts Payable">Accounts Payable</option>
                         <option value="Accounts Receivable">Accounts Receivable</option>
                         <option value="Administrative Clerk">Administrative Clerk</option>
                         <option value="Application Developer">Application Developer</option>
                         <option value="Apprentice">Apprentice</option>
                         <option value="Assistance Dispatcher">Assistance Dispatcher</option>
                         <option value="Assistant F & I Manager">Assistant F & I Manager</option>
                         <option value="Assistant Manager">Assistant Manager</option>
                         <option value="Assistant Warehouse Manager">Assistant Warehouse Manager</option>
                         <option value="Back Counter Sales">Back Counter Sales</option>
                         <option value="Body Shop Parts">Body Shop Parts</option>
                         <option value="Body Shop Parts - Exempt">Body Shop Parts - Exempt</option>
                         <option value="Body Shop Warehouse">Body Shop Warehouse</option>
                         <option value="BodyMan">BodyMan</option>
                         <option value="Cash Receipt Clerk">Cash Receipt Clerk</option>
                         <option value="Clerical">Clerical</option>
                         <option value="Contract Administrator">Contract Administrator</option>
                         <option value="Contract Maintenance">Contract Maintenance</option>
                         <option value="Controller">Controller</option>
                         <option value="Coordinator">Coordinator</option>
                         <option value="Core Management - Exempt">Multi</option>
                         <option value="Counsel">Counsel</option>
                         <option value="Customer Support Manager">Customer Support Manager</option>
                         <option value="Delivery Driver">Delivery Driver</option>
                         <option value="Estimator">Estimator</option>
                         <option value="F & I Manager">F & I Manager</option>
                         <option value="Facilities Assistant">Facilities Assistant</option>
                         <option value="Facilities Manager">Facilities Manager</option>
                         <option value="Fleet Sales Representative">Fleet Sales Representative</option>
                         <option value="Foreman">Foreman</option>
                         <option value="Front Counter Sales">Front Counter Sales</option>
                         <option value="General Manager">General Manager</option>
                         <option value="Human Resources Manager">Human Resources Manager</option>
                         <option value="Inventory Control">Inventory Control</option>
                         <option value="IT Assistant">IT Assistant</option>
                         <option value="Manager">Manager</option>
                         <option value="Network System Administrator">Network System Administrator</option>
                         <option value="Painter">Painter</option>
                         <option value="Parts Puller">Parts Puller</option>
                         <option value="PC Technician">PC Technician</option>
                         <option value="Phone Room Sales">Phone Room Sales</option>
                         <option value="Porter">Porter</option>
                         <option value="Receptionist">Receptionist</option>
                         <option value="Sales Coordinator">Sales Coordinator</option>
                         <option value="Sales Manager">Sales Manager</option>
                         <option value="Sales Representative - Parts">Sales Representative - Parts</option>
                         <option value="Sales Representative - Truck">Sales Representative - Truck</option>
                         <option value="Service Writer">Service Writer</option>
                         <option value="Shipping and Receiving">Shipping and Receiving</option>
                         <option value="Technician - Flat Rate">Technician - Flat Rate</option>
                         <option value="Technician - Hourly">Technician - Hourly</option>
                         <option value="Trainer">Trainer</option>
                         <option value="Warehouse">Warehouse</option>
                         <option value="Warehouse Manager">Warehouse Manager</option>
                         <option value="Warranty Coordinator">Warranty Coordinator</option>
                         <option value="Warranty Manager">Warranty Manager</option>
                         <option value="Wholesale">Wholesale</option>
                         <option value="Wholesale Manager">Wholesale Manager</option>
                         <option value="Will Call">Will Call</option> -->
                       </select>

                 </div>


                 <!-- <span style="margin:5px 0; font-weight:bold; color:#666">To:</span> -->
                 <div class="wrap-input1 validate-input col-md-4"   data-validate = "Job Title is required">
                   <label for="Job_Title_To">To:</label>
                       <select  name="Job_Title_To" id="Job_Title_To"  class="browser-default form-select input1"  disabled>
                         <option value="" disabled selected>Job Title</option>

                         <?php
                           foreach($job_Title['values'] as $TitleDesc) { ?>
                             <option value="<?= ucwords(strtolower($TitleDesc)); ?>"><?= ucwords(strtolower($TitleDesc)); ?></option>
                           <?php
                             } ?>
                         <!-- <option value="Accounting Assistant">Accounting Assistant</option>
                         <option value="Accounts Payable">Accounts Payable</option>
                         <option value="Accounts Receivable">Accounts Receivable</option>
                         <option value="Administrative Clerk">Administrative Clerk</option>
                         <option value="Application Developer">Application Developer</option>
                         <option value="Apprentice">Apprentice</option>
                         <option value="Assistance Dispatcher">Assistance Dispatcher</option>
                         <option value="Assistant F & I Manager">Assistant F & I Manager</option>
                         <option value="Assistant Manager">Assistant Manager</option>
                         <option value="Assistant Warehouse Manager">Assistant Warehouse Manager</option>
                         <option value="Back Counter Sales">Back Counter Sales</option>
                         <option value="Body Shop Parts">Body Shop Parts</option>
                         <option value="Body Shop Parts - Exempt">Body Shop Parts - Exempt</option>
                         <option value="Body Shop Warehouse">Body Shop Warehouse</option>
                         <option value="BodyMan">BodyMan</option>
                         <option value="Cash Receipt Clerk">Cash Receipt Clerk</option>
                         <option value="Clerical">Clerical</option>
                         <option value="Contract Administrator">Contract Administrator</option>
                         <option value="Contract Maintenance">Contract Maintenance</option>
                         <option value="Controller">Controller</option>
                         <option value="Coordinator">Coordinator</option>
                         <option value="Core Management - Exempt">Multi</option>
                         <option value="Counsel">Counsel</option>
                         <option value="Customer Support Manager">Customer Support Manager</option>
                         <option value="Delivery Driver">Delivery Driver</option>
                         <option value="Estimator">Estimator</option>
                         <option value="F & I Manager">F & I Manager</option>
                         <option value="Facilities Assistant">Facilities Assistant</option>
                         <option value="Facilities Manager">Facilities Manager</option>
                         <option value="Fleet Sales Representative">Fleet Sales Representative</option>
                         <option value="Foreman">Foreman</option>
                         <option value="Front Counter Sales">Front Counter Sales</option>
                         <option value="General Manager">General Manager</option>
                         <option value="Human Resources Manager">Human Resources Manager</option>
                         <option value="Inventory Control">Inventory Control</option>
                         <option value="IT Assistant">IT Assistant</option>
                         <option value="Manager">Manager</option>
                         <option value="Network System Administrator">Network System Administrator</option>
                         <option value="Painter">Painter</option>
                         <option value="Parts Puller">Parts Puller</option>
                         <option value="PC Technician">PC Technician</option>
                         <option value="Phone Room Sales">Phone Room Sales</option>
                         <option value="Porter">Porter</option>
                         <option value="Receptionist">Receptionist</option>
                         <option value="Sales Coordinator">Sales Coordinator</option>
                         <option value="Sales Manager">Sales Manager</option>
                         <option value="Sales Representative - Parts">Sales Representative - Parts</option>
                         <option value="Sales Representative - Truck">Sales Representative - Truck</option>
                         <option value="Service Writer">Service Writer</option>
                         <option value="Shipping and Receiving">Shipping and Receiving</option>
                         <option value="Technician - Flat Rate">Technician - Flat Rate</option>
                         <option value="Technician - Hourly">Technician - Hourly</option>
                         <option value="Trainer">Trainer</option>
                         <option value="Warehouse">Warehouse</option>
                         <option value="Warehouse Manager">Warehouse Manager</option>
                         <option value="Warranty Coordinator">Warranty Coordinator</option>
                         <option value="Warranty Manager">Warranty Manager</option>
                         <option value="Wholesale">Wholesale</option>
                         <option value="Wholesale Manager">Wholesale Manager</option>
                         <option value="Will Call">Will Call</option> -->
                       </select>

                     </div>

             </div>


             <!-- PAY -->
             <div class="row">
                  <div class="wrap-input1 validate-input col-md-4">
                     <input class="form-check-input1" type="checkbox" value="" id="PayCheckbox" >
                     <label class="form-check-label" for="PayCheckbox">Pay</label>
                  </div>


            <!-- Pay from -->
                      <div class="wrap-input1 validate-input col-md-4" data-validate = "Pay From is required">
                          <label for="Pay_From">From:</label>
                          <input type="text" class="form-control input1" name="Pay_From" id="Pay_From"  placeholder="Pay From" pattern="^\$\d{1,3}(,\d{3})*(\.\d+)?$"  data-type="currency"  value="<?php echo !empty($res['Pay_From'])?$res['Pay_From']:''; ?>"    disabled>
                      </div>

                      <div class="wrap-input1 validate-input col-md-4"   data-validate = "Pay From Per is required">
                        <label for="Pay_From_Per">Per:</label>
                            <select  name="Pay_From_Per" id="Pay_From_Per"  class="browser-default form-select input1"  disabled>
                              <option value="" disabled selected>Per</option>
                              <option value="Annum">Annum</option>
                              <option value="Hour">Hour</option>
                              <option value="Week">Week</option>

                            </select>
                      </div>
              </div>

            <!-- Pay To -->
            <div class="row">
              <div class="wrap-input1 validate-input col-md-4"></div>
                <div class="wrap-input1 validate-input col-md-4" data-validate = "Pay To is required">
                    <label for="Pay_To">To:</label>
                    <input type="text" class="form-control input1" name="Pay_To" id="Pay_To"  placeholder="Pay To" pattern="^\$\d{1,3}(,\d{3})*(\.\d+)?$"  data-type="currency"  value="<?php echo !empty($res['Pay_To'])?$res['Pay_To']:''; ?>"    disabled>
                </div>

                <div class="wrap-input1 validate-input col-md-4"   data-validate = "Per To is required">
                  <label for="Pay_To_Per">Per:</label>
                      <select  name="Pay_To_Per" id="Pay_To_Per"  class="browser-default form-select input1"  disabled>
                        <option value="" disabled selected>Per</option>
                        <option value="Annum">Annum</option>
                        <option value="Hour">Hour</option>
                        <option value="Week">Week</option>
                      </select>
                </div>
            </div>


            <!-- BRANCH -->
            <div class="row">
                 <div class="wrap-input1 validate-input col-md-4">
                    <input class="form-check-input1" type="checkbox" value="" id="BranchCheckbox" >
                    <label class="form-check-label" for="BranchCheckbox">Branch</label>
                 </div>

                 <div class="wrap-input1 validate-input col-md-4" data-validate = "From Branch is required">
                      <label for="From_Branch">From:</label>
                       <select id="From_Branch" name="From_Branch"  class="browser-default form-select input1"   disabled>
                         <option value="" disabled selected>From Branch</option>
                         <option value="010-HFI">010-HFI</option>
                         <option value="017-HDTP">017-HDTP</option>
                         <option value="020-CCFI">020-CCFI</option>
                         <option value="030-BMT">030-BMT</option>
                         <option value="060-TBGC">060-TBGC</option>
                         <option value="080-STR">080-STR</option>
                         <option value="090-STC">090-STC</option>
                       </select>
                 </div>

                 <div class="wrap-input1 validate-input col-md-4" data-validate = "To Branch is required">
                      <label for="To_Branch">To:</label>
                       <select id="To_Branch" name="To_Branch"  class="browser-default form-select input1"   disabled>
                         <option value="" disabled selected>Branch</option>
                         <option value="010-HFI">010-HFI</option>
                         <option value="017-HDTP">017-HDTP</option>
                         <option value="020-CCFI">020-CCFI</option>
                         <option value="030-BMT">030-BMT</option>
                         <option value="060-TBGC">060-TBGC</option>
                         <option value="080-STR">080-STR</option>
                         <option value="090-STC">090-STC</option>
                       </select>
                 </div>
           </div>

           <!-- Department -->
           <div class="row">
                <div class="wrap-input1 validate-input col-md-4">
                   <input class="form-check-input1" type="checkbox" value="" id="DepartmentCheckbox" >
                   <label class="form-check-label" for="DepartmentCheckbox">Department</label>
                </div>

                <div class="wrap-input1 validate-input col-md-4" data-validate = "From Department is required">
                     <label for="From_Department">From:</label>
                     <select  name="From_Department" id="From_Department"  class="browser-default form-select input1"    disabled>
                       <option value="" disabled selected>Department</option>
                       <option value="Accounting">Accounting</option>
                       <option value="Administration">Administration</option>
                       <option value="Body Shop">Body Shop</option>
                       <option value="IT">IT</option>
                       <option value="New Truck">New Truck</option>
                       <option value="Parts">Parts</option>
                       <option value="Service">Service</option>
                       <option value="Used Truck">Used Truck</option>
                     </select>
                </div>

                <div class="wrap-input1 validate-input col-md-4" data-validate = "To Department is required">
                     <label for="To_Department">To:</label>
                     <select  name="To_Department"  id="To_Department" class="browser-default form-select input1"   disabled>
                       <option value="" disabled selected>Department</option>
                       <option value="Accounting">Accounting</option>
                       <option value="Administration">Administration</option>
                       <option value="Body Shop">Body Shop</option>
                       <option value="IT">IT</option>
                       <option value="New Truck">New Truck</option>
                       <option value="Parts">Parts</option>
                       <option value="Service">Service</option>
                       <option value="Used Truck">Used Truck</option>
                     </select>
                </div>
          </div>


          <!-- Employment Status -->
          <div class="row">
               <div class="wrap-input1 validate-input col-md-4">
                  <input class="form-check-input1" type="checkbox" value="" id="EmpStatusCheckbox" >
                  <label class="form-check-label" for="EmpStatusCheckbox">Employment Status</label>
               </div>

               <div class="wrap-input1 validate-input col-md-4" data-validate = "From Department is required">
                    <label for="From_Employee_Status">From:</label>
                    <select  name="From_Employee_Status" id="From_Employee_Status"   class="browser-default form-select input1"  disabled>
                      <option value="" disabled selected>Employment Status</option>
                      <option value="Full-time Regular">Full-time Regular</option>
                      <option value="Full-time Temporary">Full-time Temporary</option>
                      <option value="FMLA">FMLA</option>
                      <option value="Light Duty">Light Duty</option>
                      <option value="Part-time Regular">Part-time Regular</option>
                      <option value="Part-time Temporary">Part-time Temporary</option>
                      <option value="USERRA">USERRA</option>
                      <option value="Other Leave">Other Leave</option>
                    </select>
               </div>

               <div class="wrap-input1 validate-input col-md-4" data-validate = "To Department is required">
                    <label for="To_Employee_Status">To:</label>
                    <select  name="To_Employee_Status"  id="To_Employee_Status"  class="browser-default form-select input1"  disabled>
                      <option value="" disabled selected>Employment Status</option>
                      <option value="Full-time Regular">Full-time Regular</option>
                      <option value="Full-time Temporary">Full-time Temporary</option>
                      <option value="FMLA">FMLA</option>
                      <option value="Light Duty">Light Duty</option>
                      <option value="Part-time Regular">Part-time Regular</option>
                      <option value="Part-time Temporary">Part-time Temporary</option>
                      <option value="USERRA">USERRA</option>
                      <option value="Other Leave">Other Leave</option>
                    </select>
               </div>
         </div>

         <!-- Remarks -->
           <div class="wrap-input1 validate-input1" data-validate = "Remarks is required">
               <h6 style="margin-bottom:3px; text-transform: uppercase;">Use the remarks section below to note any specific usage rights or logins needed for this employee</h6>
               <textarea class="form-control input1" name="Change_Remarks" placeholder="Remarks"><?php echo !empty($postData['Change_Remarks'])?$postData['Change_Remarks']:''; ?></textarea>
               <span class="shadow-input1"></span>
           </div>


  </fieldset>

</div><!-- END OF Change Section Div -->


<!-- SEPARATION SECTION -->
<div id="separationSection" style="display:none" class="row">

  <!-- <div id="separation"> -->
     <fieldset class="SeparationSection scheduler-border"><br />
         <legend class="scheduler-border">SEPARATION</legend>

           <div class="row">
               <div class="wrap-input1 validate-input col-md-4 date" data-validate = "Hire Date is required" data-provide="datepicker" data-date-format="yyyy/mm/dd">
                 <input class="form-control input1 date-withicon" type="text"  name="Hire_Date"  id="Hire_Date"  placeholder="Hire Date"  value="<?php echo !empty($res['Hire_Date'])?$res['Hire_Date']:''; ?>"  required>
                 <div class="input-group-addon"></div>
               </div>

               <div class="wrap-input1 validate-input col-md-4 date" data-validate = "Last Day Worked is required" data-provide="datepicker" data-date-format="yyyy/mm/dd">
                 <input class="form-control input1 date-withicon" type="text"  name="Last_Day_Worked"  id="Last_Day_Worked"  placeholder="Last Day Worked"  value="<?php echo !empty($res['Last_Day_Worked'])?$res['Last_Day_Worked']:''; ?>"  required>
                 <div class="input-group-addon"></div>
               </div>

               <div class="wrap-input1 validate-input col-md-4 date" data-validate = "Separation Date is required" data-provide="datepicker" data-date-format="yyyy/mm/dd">
                 <input class="form-control input1 date-withicon" type="text"  name="Separation_Date"  id="Separation_Date"   placeholder="Separation Date"  value="<?php echo !empty($res['Separation_Date'])?$res['Separation_Date']:''; ?>"  required>
                 <div class="input-group-addon"></div>
               </div>
           </div>

           <div class="row">
                <div class="wrap-input1 validate-input col-md-4" data-validate = "Type is required">
                     <select  name="Separation_Type" id="Separation_Type"   class="browser-default form-select input1"  >
                       <option value="" disabled selected>Type</option>
                       <option value="Involuntary">Involuntary</option>
                       <option value="Uncontrollable">Uncontrollable</option>
                       <option value="Voluntary">Voluntary</option>
                     </select>
                </div>

                <div class="wrap-input1 validate-input col-md-4" data-validate = "Reason is required">
                     <select  name="Separation_Reason" id="Separation_Reason"   class="browser-default form-select input1"  >
                       <option value="" disabled selected>Reason</option>
                       <option value="Attendance">Attendance</option>
                       <option value="Company Policy Violation">Company Policy Violation</option>
                       <option value="Insubordination">Insubordination</option>
                       <option value="Lay Off">Lay Off</option>
                       <option value="Resigned">Resigned</option>
                       <option value="Retirement">Retirement</option>
                       <option value="Substandard Performance">Substandard Performance</option>
                     </select>
                </div>

                <div class="wrap-input1 form-group col-md-4"  id="hideEligible">
                   <div class="form-check form-check-inline">
                     <label id="EligibleTitle">Eligible for Rehire</label><br />
                     <input class="form-check-input" type="radio" value="Yes" name="Eligible_to_Rehire" id="Eligible_to_Rehire" >
                     <label class="form-check-label" for="Eligible_to_Rehire">Yes</label>
                   <!-- </div> -->
                  <!-- <div class="form-check form-check-inline"> -->
                     <input class="form-check-input" type="radio" value="No" name="Eligible_to_Rehire" id="Eligible_to_Rehire" >
                     <label class="form-check-label" for="Eligible_to_Rehire">No</label>
                  </div>
                </div>


              <div class="wrap-input1 form-group col-md-12">
                   <div class="form-check form-check-inline col-md-4">
                       <label>Forward this User’s Emails?</label><br />
                       <input class="form-check-input" type="radio" value="Yes" name="forward_emails" id="forwardYes" onclick="javascript:forwardEmailtoAnotherEmpCheck();">
                       <label class="form-check-label" for="forward_emails">Yes</label>

                       <input class="form-check-input" type="radio" value="No" name="forward_emails" id="forwardNo" onclick="javascript:forwardEmailtoAnotherEmpCheck();">
                       <label class="form-check-label" for="forward_emails">No</label>
                   </div>

                   <div id="forwardingEmployee" style="display:none;">
                        <div class="wrap-input1 validate-input col-md-4" data-validate = "Full Name is required">
                            <input class="form-control input1" type="text" name="forwarding_to_employee_name" id="forwarding_to_employee_name"  value="<?php echo !empty($res['forwarding_to_employee_name'])?$res['forwarding_to_employee_name']:''; ?>" placeholder="Forwarding to Employee Name"  required>
                            <!-- <span class="shadow-input1"></span> -->
                        </div>
                  </div>
              </div>
          </div>


          <!-- Remarks -->
            <div class="wrap-input1 validate-input1" data-validate = "Remarks is required">
                <textarea class="form-control input1" name="Separation_Remarks" id="Separation_Remarks" placeholder="Remarks"><?php echo !empty($postData['Separation_Remarks'])?$postData['Separation_Remarks']:''; ?></textarea>
                <span class="shadow-input1"></span>
            </div>

         </fieldset>

</div><!-- END OF Separation Section Div -->

<br />
                    <div class="container-contact2-form-btn">
                                <!-- <input type="submit" name="submit" class="contact1-form-btn" value="SUBMIT">                  -->
                                <button class="contact2-form-btn" type="submit" id="submit2" name="submit2" onclick='btnclick2("Personnel Action Notice","submit2","container-contact2");'>
                                    <span>
                                        SUBMIT
                                        <i class="fa fa-long-arrow-right" aria-hidden="true"></i>
                                    </span>
                                </button>
                    </div>

                    <div>
                    <!-- Display Error status -->
                                <!-- <br> -->
                                <?php if(!empty($statusMsg)){ ?>
                                    <p class="statusMsg <?php echo !empty($msgClass)?$msgClass:''; ?>"><?php echo $statusMsg; ?></p>
                                <?php } ?>
                  </div><br /><br />

<!-- End of ShowHide Div -->

                </div><!-- End of target div2 -->

                </form>
              </div>  <!-- End of container-contact2 -->

    </div>
    <!-- End of scrolldiv -->

</div>
  <!-- centering the entire div -->




                    <?php
                    }
                    else
                    {

                      // echo '<script>$("#loginModal").hide();</script>';

                    ?>
                    <div align="center">
                         <!-- <button type="button" name="login" id="login" class="btn btn-success" data-toggle="modal" data-target="#loginModal">Login</button> -->
                         <!-- <button id="DivIdToScroll3" type="button" target="2" data-toggle="modal" data-target="#loginModal"  class="btn success showSingle" name="btnPN"  id="btnPN"  >PERSONNEL<br>NOTICE</button> -->
                    </div>
                    <?php
                    }
                    ?>
               </div>
           <br />

      </body>
 </html>



<!-- Add this data-keyboard="false" data-backdrop="static" to div below disables click away from modal closing of modal -->
 <div id="loginModal" class="modal fade" role="dialog">
      <div class="modal-dialog">
   <!-- Modal content-->
           <div class="modal-content">
                <div class="modal-header">

                     <h4 class="modal-title">LOGIN &nbsp;<small style="color:red">(For Managers only)</small></h4>
                     <button type="button" class="close" id="closeLoginModal"  data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body" align="left">

                   <form  id="login_Form" class="contact1-form"    method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" enctype="multipart/form-data" >
                     <p>
                       Please enter your Phoenix credentials below.
                     </p><br />
                     <p class="form-group">
                     <label>EmployeeID</label>
                     <input type="text" name="user" id="user" class="form-control"   pattern="[0-9]*"  required="required" />
                   </p>

                   <p class="form-group">
                     <label>Password</label>
                     <input type="password" name="pass" id="pass" class="form-control"  required="Required" />
                     <br />
                     <button type="submit" name="login_button"   id="login_button" class="contact1-form-btn">Login</button>
                   </p>
                     <br />
                     <!-- Error Messages -->
                     <div class='alert alert-danger' id='errors' style="display:none">Please enter Manager's EmployeeID and Password</div>
                     <div class=' alert-danger' id='alertForm' style="display:none"></div>

                   </form>
                </div>
           </div>
      </div>
 </div>

 <div class="col-md-12">
   <!-- <?php echo $error; ?> -->
 </div>


 <script>

 function HideContainerOne() {
   var x = document.getElementById("container-contact1");
   if (x.style.display === "block") {
     x.style.display = "none";
   // } else {
     // x.style.display = "none";
   }
 }


 // function HideContainerTwo() {
 //   var x = document.getElementById("container-contact2");
 //   if (x.style.display === "none") {
 //     x.style.display = "block";
 //   } else {
 //     x.style.display = "none";
 //   }
 // }


 $(document).ready(function(){

      $('#login_button').click(function(e){
          // console.log('test1');
          // e.preventDefault();
          // $("#container-contact1").addClass("showww");
           var user = $('#user').val().trim();
           var pass = $('#pass').val().trim();

           if (user != '' && pass != '')
           {
                // console.log('test2');
                // console.log(user);
                // console.log(pass);
             // // e.preventDefault();
                $.ajax({
                     url:"action.php",
                     method:"POST",
                     async: 'false',
                     cache: 'false',
                     data: {user:user, pass:pass},
                     // dataType:"text",
                     success:function(data)
                     {
                       // console.log('test3');
                       // alert(user);

                       // alert('am here');

                         // $('#loginModal').hide();
  // $("#container-contact2").append("#container-contact2").fadeIn('slow');
   //
                             // console.log(data);
                             if ((data.success)) {
                               // location.reload();
                               // console.log(data);
                                // e.preventDefault();
                                // console.log(data);




                               // e.preventDefault();
                               // $('#container-contact2').appendTo($('/helpdesk/index.php').html());
                               // $("#container-contact2").ajaxSubmit({url: '/helpdesk/index.php', type: 'post'});
                               // $('#container-contact2').load('/helpdesk/index.php/#container-contact2').fadeIn("slow");
                               // $("#container-contact2").show();
                               // document.getElementById('#container-contact2').style.display="block";
                               // $("#container-contact2").appendTo(location.href + "#container-contact2");
                               // $("#container-contact2").appendTo(location.href+"#container-contact2>*","");
                               // location.reload();

                             //
                             } else {
                               document.getElementById('alertForm').style.display = "block";
                               // $('#alertForm').append(data);
                               // $('.ajax').remove(data);
                                // $("#alertForm").next('div').remove();
                                // $('#alertForm').append(data).show().fadeOut(8000);
                                $('#alertForm').append(data).show();
                                 // location.reload();

                             }

                     },
  // console.log('test4');
                     // error: function(e){
                     //   alert(e);
                     // }
                });
                return false;
           }
           else
           {
            // console.log('test5');
              // $('#alertForm').html("");
             // document.getElementById('alertForm').style.display = "block";
             document.getElementById('errors').style.display='block'
             $('#errors').show().fadeOut(8000);

             // alert("Both Fields are required");

           }
      });

      // setInterval(function(){
      //   $('#container-contact2').load('index.php').fadeIn('slow');
      // }, 1000);

//       setInterval(function(){
//       $("#container-contact2").load(window.location.href + " #container-contact2" );
// }, 1000);
    });






 </script>


 <!--===========================================All JS Files====================================================-->
    <!-- Jquery Library -->
    <!-- <script src="/hdesk/helpdesk/vendor/jquery/jquery-3.2.1.min.js"></script> -->
    <!-- Main JS file -->
    <script src="/hdesk/helpdesk/js/main.js"></script>

    <!-- Old Datepicker -->
    <!-- <script type= "text/javascript" src= "https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script> -->
    <!-- <link rel= "stylesheet" href= "https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css"/> -->

    <!-- New Datepicker and hide the jqery library above "/hdesk/helpdesk/vendor/jquery/jquery-3.2.1.min.js"-->
    <script type= "text/javascript" src= "https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.6.1/js/bootstrap-datepicker.min.js"></script>
    <link rel= "stylesheet" href= "https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.6.1/css/bootstrap-datepicker.min.css"/>

 <!--===============================================================================================-->
