<?php
// to show all errors
error_reporting(E_ALL);
ini_set('display_errors', '1');

// To hide all errors
// error_reporting(0);
// ini_set('display_errors', 0);


// Using database connection file here
include_once "../db_connection.php";


?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1" />

    <title>PAN RESUBMISSION EMAIL</title>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.3/css/jquery.dataTables.min.css">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <!-- Font Awesome icon Library -->
    <link rel="stylesheet" href="https://pro.fontawesome.com/releases/v5.10.0/css/all.css" integrity="sha384-AYmEC3Yw5cVb3ZcuHtOA93w35dYTsvhLPVnYs9eStHfGJvOvKxVfELGroGkvsg+p" crossorigin="anonymous"/>

     <!-- Fonts -->
     <link rel="stylesheet" type="text/css" href="../../helpdesk/css/util.css">

     <!-- Responsive Table -->
     <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
     <link rel="stylesheet" href="../../helpdesk/css/responsiveTable.css">
     <script src="../../helpdesk/js/responsiveTable.js"></script>

       <!--===============================================================================================-->
        <!-- This is to create an App Icon when you save to you website to your homescreen.
             Use the website www.favicon-generator.org/ to create an app icon and the code from the same website -->

             <link rel="apple-touch-icon" sizes="57x57" href="../Images/icons/Icons/apple-icon-57x57.png">
             <link rel="apple-touch-icon" sizes="60x60" href="../Images/icons/Icons/apple-icon-60x60.png">
             <link rel="apple-touch-icon" sizes="72x72" href="../Images/icons/Icons/apple-icon-72x72.png">
             <link rel="apple-touch-icon" sizes="76x76" href="../Images/icons/Icons/apple-icon-76x76.png">
             <link rel="apple-touch-icon" sizes="114x114" href="../Images/icons/Icons/apple-icon-114x114.png">
             <link rel="apple-touch-icon" sizes="120x120" href="../Images/icons/Icons/apple-icon-120x120.png">
             <link rel="apple-touch-icon" sizes="144x144" href="../Images/icons/Icons/apple-icon-144x144.png">
             <link rel="apple-touch-icon" sizes="152x152" href="../Images/icons/Icons/apple-icon-152x152.png">
             <link rel="apple-touch-icon" sizes="180x180" href="../Images/icons/Icons/apple-icon-180x180.png">
             <link rel="icon" type="image/png" sizes="192x192"  href="../Images/icons/Icons/android-icon-192x192.png">
             <link rel="icon" type="image/png" sizes="32x32" href="../Images/icons/Icons/favicon-32x32.png">
             <link rel="icon" type="image/png" sizes="96x96" href="../Images/icons/Icons/favicon-96x96.png">
             <link rel="icon" type="image/png" sizes="16x16" href="../Images/icons/Icons/favicon-16x16.png">
             <link rel="mask-icon" href="../Images/icons/Icons/safari-pinned-tab.svg" color="#5bbad5">
             <link rel="manifest" href="../Images/icons/Icons/manifest.json">
             <meta name="msapplication-TileColor" content="#ffffff">
             <meta name="msapplication-TileImage" content="../Images/icons/Icons/ms-icon-144x144.png">
             <meta name="theme-color" content="#ffffff">


             <!-- Bootstrap CSS -->
             <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
             <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">

             <!-- Main CSS -->
             <link rel="stylesheet" href="../css/PANtrackDashboard.css"></link>

             <!-- Font Awesome -->
             <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css">


<style>

#formDataTable th {
    text-align: center;
    padding: 12px 20px;
}

body, html {
  min-height: 100%;
  font-family: 'Montserrat-Regular', sans-serif;
}


.table th, .table td  {
	border: 1px solid #eee;
	border-top: none;
  border-collapse: collapse;
  text-transform: uppercase;
}

/* tr.even td {
  background: #ecece9 none repeat scroll 0 0;
} */

</style>


</head>
<body><br />
  <div class="container-fluid">
      <div class="table-responsive">
         <table id="formDataTable" class="datatable table table-striped table-hover" id="dataList" class="display" style="width:100%;">
            <thead style="position: sticky;top: 0;" class="thead-dark">
                <tr>
                  <td colspan="13" style="background-color:#ddd; font-weight:bold; text-align:center">
                    <h4>Resubmit PAN Email to Manager for Approval</h4>
                  </td>
                </tr>
                <tr id="tableHeaders" ></tr>
            </thead>


            <tbody>
            </tbody>
        </table>

      </div>
  </div><br />


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script>
    // $(document).ready(function() {
    //     $.ajax({
    //         url: 'Fetch_Submitted_Data.php',
    //         method: 'GET',
    //         dataType: 'json',
    //         success: function(data) {
    //             console.log(data);
    //
    //             if (Array.isArray(data) && data.length > 0) {
    //
    //                 //  Only include these columns (in this order)
    //                 var allowedColumns = ["PAN_ID", "FormType", "Attachment", "first_name", "last_name", "branch", "department", "fromName", "Approval_Status", "ApprovedBy"];
    //
    //                 var columns = [];
    //                 var headers = "";
    //
    //                 allowedColumns.forEach(function(col) {
    //                     headers += `<th>${col.replace(/_/g, ' ')}</th>`;
    //                     columns.push({ data: col, title: col.replace(/_/g, ' ') });
    //                 });
    //
    //                 //  Add Action column at the end
    //                 headers += "<th>Action</th>";
    //                 columns.push({
    //                     data: null,
    //                     render: function(data, type, row) {
    //                         return `<button class="btn btn-primary" onclick="resendEmail(${row.PAN_ID}, '${row.FormType}')">Resend Email</button>`;
    //                     }
    //                 });
    //
    //                 //  Inject headers
    //                 $("#tableHeaders").html(headers);
    //
    //                 //  Initialize DataTable
    //                 $('#formDataTable').DataTable({
    //                     data: data,
    //                     columns: columns
    //                 });
    //             } else {
    //                 console.log("No data available");
    //             }
    //         },
    //         error: function(xhr, status, error) {
    //             console.error("Error fetching data:", status, error);
    //         }
    //     });
    // });


    $(document).ready(function () {
        $.ajax({
            url: 'Fetch_Submitted_Data.php',
            method: 'GET',
            dataType: 'json',
            success: function (data) {
                // console.log(data);

                // if (Array.isArray(data) && data.length > 0) {

                    // Allowed DB columns (excluding first_name and last_name)
                    var allowedColumns = [
                        "PAN_ID",
                        "FormType",
                        "effective_date",
                        "Attachment",
                        "branch",
                        "department",
                        "fromName",
                        "Approval_Status",
                        "ApprovedBy",
                        "last_resubmitted_at"
                    ];

                    // Mapping for user-friendly headers
                    var columnNameMap = {
                        "PAN_ID": "PAN ID",
                        "FormType": "Form Type",
                        "effective_date": "Effective Date",
                        "Attachment": "Attachment",
                        "branch": "Branch",
                        "department": "Department",
                        "fromName": "Submitted By",
                        "Approval_Status": "Status",
                        "ApprovedBy": "Sent For Approval To",
                        "last_resubmitted_at": "Last Reminder Sent On"
                    };

                    var columns = [];
                    var headers = "";

                    // Add PAN ID first
                    headers += `<th>${columnNameMap["PAN_ID"].toUpperCase()}</th>`;
                    columns.push({
                        data: "PAN_ID",
                        title: columnNameMap["PAN_ID"].toUpperCase(),
                        render: function (data) {
                            return data ? data : "N/A";
                        }
                    });


                    headers += '<th>Submitted On</th>';
                    columns.push({ data: 'timeStamp', title: 'SUBMITTED ON' });

                    // Add FULL NAME next (merged first_name + last_name)
                    headers += `<th>FULL NAME</th>`;
                    columns.push({
                        data: null,
                        title: "FULL NAME",
                        render: function (data, type, row) {
                            const firstName = row.first_name || '';
                            const lastName = row.last_name || '';
                            const fullName = `${firstName} ${lastName}`.trim();
                            return fullName !== "" ? fullName : "N/A";
                        }
                    });

                    // Add remaining columns (starting from index 1 to skip PAN_ID)
                    allowedColumns.slice(1).forEach(function (col) {
                        const headerText = (columnNameMap[col] || col).toUpperCase();
                        headers += `<th>${headerText}</th>`;

                        columns.push({
                            data: col,
                            title: headerText,
                            render: function (data, type, row) {
                                const value = row[col];
                                // Special handling for Attachment
                                if (col === "Attachment") {
                                    return value && value.trim() !== "" ? value : "N/A";
                                }
                                return value && value.toString().trim() !== "" ? value : "N/A";
                            }
                        });
                    });

                    // Add ACTION column
                    headers += `<th>ACTION</th>`;
                    columns.push({
                        data: null,
                        title: "ACTION",
                        render: function (data, type, row) {
                            return `<button class="btn btn-primary" onclick="resendEmail(${row.PAN_ID}, '${row.FormType}')">Resend Email</button>`;
                        }
                    });

                    // Inject headers into the table
                    $("#tableHeaders").html(headers);

                    // Initialize DataTable with sorting by PAN_ID (descending)
                    $('#formDataTable').DataTable({
                        data: Array.isArray(data) ? data : [],
                        columns: columns,
                        order: [[0, 'desc']], // 0 = PAN_ID column
                        "language": {
                            emptyTable: "No PAN available to resend"
                        },
                        "columnDefs": [
                          { "className": "dt-center", "targets": [0, 1, 2, 3, 4, 6, 7, 8, 9, 10] }], // Center columns
                    });

                    // Optional console log
                if (!Array.isArray(data) || data.length === 0) {
                    console.log("No PAN available to resend");
                }
            },
            error: function (xhr, status, error) {
                console.error("Error fetching data:", status, error);
                $("#tableHeaders").html("<th>Error</th>");
                $('#formDataTable').DataTable({
                    data: [],
                    columns: [{ title: "Error", data: null, defaultContent: "Failed to load data" }],
                    language: { emptyTable: "Unable to load data from server" }
                });
            }
        });
    });

    function resendEmail(id, personnelOnly) {
        $.ajax({
            url: 'resendEmail.php',
            method: 'POST',
            data: { id: id, FormType: personnelOnly},
            success: function(response) {
                alert(response);
            },
            error: function(xhr, status, error) {
                console.error("Error sending email:", status, error);
            }
        });
    }
    </script>


</body>
</html>
